<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;
if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
global $product, $current_user;
setPostViews($post->ID);
	if(get_post_status( $post->ID ) == 'expired'){ ?>
		<section>
				<div class="alert alert-warning" role="alert">
						<h2 class="alert-heading"><i class="fa fa-lock" aria-hidden="true"></i> <?php _e('The requested ad has expired.' , 'charsoogh'); ?></h2>
						<p><?php _e('Sorry, your ad has expired.' , 'charsoogh'); ?></p>
				</div>
		</section>
<?php	return; }
$author_id = $post->post_author;
$current_user = wp_get_current_user();
if($author_id != $current_user->ID){
	if(get_post_status( $post->ID ) != 'publish'){
	?>
	<section>
			<div class="alert alert-warning" role="alert">
					<h2 class="alert-heading"><i class="fa fa-lock" aria-hidden="true"></i> <?php _e('Pending Management approval' , 'charsoogh'); ?></h2>
					<p><?php _e('Your ad will be published on the site after management approval.' , 'charsoogh'); ?></p>
			</div>
	</section>
<?php
	return;
	}
}elseif($author_id == $current_user->ID && get_post_status( $post->ID ) != 'publish'){ ?>
	<section>
			<div class="alert alert-warning" role="alert">
					<h2 class="alert-heading"><i class="fa fa-lock" aria-hidden="true"></i> <?php _e('Pending Management approval' , 'charsoogh'); ?></h2>
					<p><?php _e('Your ad will be published on the site after management approval.' , 'charsoogh'); ?></p>
			</div>
	</section>
<?php } ?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class(); ?>>
	<div class="row flex-md-row">

<?php if (get_theme_mod( 'charsoogh_single_ads_layout' ) == 'sidebar_right'){ get_sidebar('shop'); } ?>
			<!--============ Listing Detail =============================================================-->
			<div class="col-md-8 charsoogh-content" <?php if(get_theme_mod('charsoogh_ad_sticky_sidebar' , 'yes') == 'yes'): echo 'id="content"'; endif; ?>>
				<?php $slider_style = get_theme_mod( 'charsoogh_single_ad_slider' , 'style-1' ); ?>
				<?php include_once( get_template_directory() . '/template/ads/slider-' . $slider_style . '.php' ); ?>
				<?php if(get_theme_mod( 'charsoogh_content_single_ad_show' ) == 'under_images'){ ?>
					<!--Description-->
					<section class="box">
	            <h2 class="box-title"><?php _e('Ad Description' , 'charsoogh'); ?></h2>
							<span class="collapse-arrow" data-toggle="collapse" href="#collapseContent" role="button" aria-expanded="false" aria-controls="collapseContent">
								<i class="fa fa-minus" aria-hidden="true"></i>
							</span>
	            <div class="b-line"></div>
							<div class="collapse show" id="collapseContent">
	            <?php the_content(); ?>
							</div>
	        </section>
				<?php } ?>
				<?php if(!empty(get_option('map_activation')) && get_option('map_activation') == 'on'){ ?>
				<?php if(get_theme_mod( 'charsoogh_content_single_map_show' ) == 'under_images'){ ?>
					<?php if(!empty(get_post_meta($post->ID , '_ad_latitude' , true)) && !empty(get_post_meta($post->ID , '_ad_longitude' , true))){ ?>
	        <section class="box mapbox" style="padding: 5px;">
	          <div class="ribbon-featured"><div class="ribbon-start"></div><div class="ribbon-content"><?php _e('Ad Location on Map' , 'charsoogh'); ?></div><div class="ribbon-end"><figure class="ribbon-shadow"></figure></div></div>
	          <div id='map' style='width: 100%; height: 300px;'></div>
						<a href="http://maps.google.com/maps?q=loc:<?php echo get_post_meta($post->ID , '_ad_latitude' , true); ?>,<?php echo get_post_meta($post->ID , '_ad_longitude' , true); ?> (<?php the_title(); ?>)" target="_blank">
						<button type="button" class="btn btn-primary info-btn location-send"></i> <?php _e('Navigation' , 'charsoogh'); ?></button>
						</a>
						<?php
						$mapbox_style = get_theme_mod( 'charsoogh_map_style' , 'light-v10');
						$mapbox_marker = get_theme_mod( 'charsoogh_map_marker' , IMAGES ."/" . "icon/marker-icon.png");
						 ?>
						<script>
	          jQuery(document).ready(function() {
	          var token = "<?php echo get_option('mapbox_token_key'); ?>";
	          var map = L.map('map').setView([<?php echo get_post_meta($post->ID , '_ad_latitude' , true); ?>, <?php echo get_post_meta($post->ID , '_ad_longitude' , true); ?>], 16);

						L.marker(
	                 [<?php echo get_post_meta($post->ID , '_ad_latitude' , true); ?>, <?php echo get_post_meta($post->ID , '_ad_longitude' , true); ?>],
	               {
	              icon: new L.DivIcon({
	              className: 'l-marker-icon',
	              html: '<img class="l-marker-image" src="<?php echo $mapbox_marker; ?>" width="25px" height="41px"/>'+
	           '<span class="l-marker-span"><?php echo wp_trim_words( get_the_title(), 3, '...' ); ?></span>',
	              iconSize: [25, 41],
	              iconAnchor: [25, 41],
	              }),
	               riseOnHover: true,
	               draggable: false,
	               autoPan: true,
	              }
	            ).addTo(map);
	            L.tileLayer('https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=' + token, {
	                maxZoom: 18,
	                minZoom: 5,
	                id: 'mapbox/<?php echo $mapbox_style; ?>',
	                tileSize: 512,
	                zoomOffset: -1,
	                accessToken: token
	            }).addTo(map);


	          });
	          </script>
	        </section>
				<?php
				} // Check Map Activation Lat & Long
			 } // Check map Position
		 } // Check Map Activation
			?>

				<?php
					 if ( is_active_sidebar( 'ads_bottom_sidebar_widgets' ) ) :
							 dynamic_sidebar( 'ads_bottom_sidebar_widgets' );
						 endif;
					?>
					<?php if ( comments_open() ) : ?>
					<section class="box">
						<h2 class="box-title"><?php _e('Express your opinion' , 'charsoogh'); ?></h2>
						<span class="collapse-arrow" data-toggle="collapse" href="#collapseComments" role="button" aria-expanded="false" aria-controls="collapseComments">
							<i class="fa <?php if(!check_is_mobile_agent()): echo 'fa-minus'; else: echo 'fa-plus'; endif;?>" aria-hidden="true"></i>
						</span>
						<div class="b-line"></div>
						<div class="collapse <?php if(!check_is_mobile_agent()): echo 'show'; endif;?>" id="collapseComments">
						<?php comments_template(); ?>
						</div>
					</section>
					<?php endif; ?>
					<?php
					if (get_theme_mod( 'charsoogh_ad_tags') != 'no') :
					$ads_tags = get_the_terms($post->ID, 'product_tag');
					if($ads_tags && !empty($ads_tags)):
					?>
					<div class="charsoogh_tags">
					<span>
						<i class="fa fa-tags" aria-hidden="true"></i> <?php _e('Tags: ' , 'charsoogh'); ?>
					</span>
					<?php the_terms( $post->ID, 'product_tag', ' ', '', ''  );?>
					</div>
					<?php endif; endif; ?>
			</div>
<?php if (get_theme_mod( 'charsoogh_single_ads_layout' ) == 'sidebar_left' || empty(get_theme_mod( 'charsoogh_single_ads_layout' ))){ get_sidebar('shop'); } ?>
	</div>
	<?php woocommerce_output_related_products(); ?>
</div>
<?php do_action( 'woocommerce_after_single_product' ); ?>
<?php get_template_part('template/report-ad'); ?>
