<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 * Re-design by Tik4.com
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.9.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' ); ?>
<main class="content">
            <section class="block">
	<div class="container">
<div class="section-title clearfix">
<?php
if ( woocommerce_product_loop() ) {
woocommerce_catalog_ordering();
	?>
  <?php
  if(!is_shop() || is_search()){
  require_once(get_template_directory() . '/includes/models/charsoogh_ads_posts.php');
  $search_class_fields = new charsoogh_posts();
  $category = get_queried_object();
  $exist_cat = false;
  if(!empty($category->term_id)){
  $fields = $search_class_fields -> getCatFields($category->term_id);
  //price_divShow
  $none_price = get_option('none_price_cat');
  if(is_array($none_price)){
  if(in_array($category->term_id , $none_price)){$exist_cat = true;}
  }
}else{
  $fields = array();
}
$cookie_city = @$_COOKIE['city_user'];
$wcatTerms = get_terms('city_categories', array('hide_empty' => 0, 'parent' =>0));
foreach($wcatTerms as $wcatTerm) :
if($cookie_city == $wcatTerm->term_id){
$city_selected = $wcatTerm->name;
$city_selected_slug = $wcatTerm->slug;
}
endforeach;
if(empty(get_theme_mod( 'charsoogh_adv_search_type')) || get_theme_mod( 'charsoogh_adv_search_type') == 'sidebar'){
  $filter_type = 'data-toggle="modal"';
  $filter_target = 'data-target="#charsoogh_filter_show"';
}else{
  $filter_type = 'data-toggle="collapse"';
  $filter_target = 'href="#collapseAlternativeSearchForm"';
}
    ?>
  <div class="form-group search_filters">
<div class="alternative-search-form">
    <a <?php echo $filter_target; ?> class="icon collapsed"  <?php echo $filter_type; ?> aria-hidden="true" aria-controls="collapseAlternativeSearchForm"><i class="fa fa-plus"></i><?php _e('Advanced Search' , 'charsoogh'); ?></a>

  <?php
if(get_theme_mod( 'charsoogh_adv_search_type') == 'collapse'){
  get_template_part('template/archive/collapse');
}
   ?>

<?php add_action('wp_footer',function(){ ?>
  <script> var ajaxurl = '<?php echo admin_url("admin-ajax.php") ?>'; </script>
<?php });
add_action('wp_footer','wp_ajax_searchFilter');
add_action('admin_footer','wp_ajax_searchFilter');
function wp_ajax_searchFilter(){
?>
    <script>
    var page = 1;
    var search = '';
    <?php if(is_search()){ ?>
      /////////////////// Get URL Parameters //////////////////
      var getUrlParameter = function getUrlParameter(sParam) {
      var sPageURL = window.location.search.substring(1),
          sURLVariables = sPageURL.split('&'),
          sParameterName,
          i;
      for (i = 0; i < sURLVariables.length; i++) {
          sParameterName = sURLVariables[i].split('=');
          if (sParameterName[0] === sParam) {
              return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
          }
        }
      };
    search = getUrlParameter('s');
    var city_categories = getUrlParameter('city_categories');
    var product_cat = getUrlParameter('product_cat');
    <?php }if(is_product_category() || is_tax() && !is_search()){
      $cookie_city = @$_COOKIE['city_user'];
      if($cookie_city && $cookie_city != 'all'){
        $term = get_term( $cookie_city, 'city_categories' );
        $citySlug = $term->slug;
      }else{$citySlug = 0;}

      ?>
    <?php if(is_product_category()){ ?>
    var city_categories = '<?php echo $citySlug; ?>';
    var product_cat = '<?php global $wp_query; echo $wp_query->get_queried_object()->slug; ?>';
    <?php }else{ ?>
      var filter_city_categories = '';
      var city_categories = '<?php global $wp_query; echo $wp_query->get_queried_object()->slug; ?>';
      var product_cat = '';
    <?php } ?>
    <?php } ?>
    jQuery('.submit-advance').click(function(e){
      var filter_city_categories = jQuery('.filter_city_categories').find("option:selected").val();
      e.preventDefault();
      var fd = new FormData();
      var form_data = jQuery('#search_submit').serialize();
      fd.append("form_data", form_data);
      jQuery(".loading").css("display", "block");
      var page = 1;
      var data = {
          action: 'searchfilter_action',
          data: form_data,
          search: search,
          product_cat: product_cat,
          city_categories: city_categories,
          filter_city_categories: filter_city_categories,
          page: page,
          security: '<?php echo wp_create_nonce("search_category_posts"); ?>'
      }
      jQuery.post(ajaxurl,data,function(response){
          jQuery("div.category_search_content").html(response);
          jQuery(".loading").css("display", "none");
          jQuery('[data-toggle="tooltip"]').tooltip();
          jQuery(".ribbon-featured").each(function() {
              var thisText = jQuery(this).text();
              jQuery(this).html("");
              jQuery(this).append(
                  "<div class='ribbon-start'></div>" +
                  "<div class='ribbon-content'>" + thisText + "</div>" +
                  "<div class='ribbon-end'>" +
                      "<figure class='ribbon-shadow'></figure>" +
                  "</div>"
              );
          });
      });

    });


    jQuery('body').on('click', '.loadmore', function() {
      page++;
      jQuery(".ad-loading").css("display", "block");
      jQuery(".loadmore").hide();
      var fd = new FormData();
      var form_data = jQuery('#search_submit').serialize();
      fd.append("form_data", form_data);
      var data = {
          action: 'searchfilter_action',
          data: form_data,
          search: search,
          product_cat: product_cat,
          city_categories: city_categories,
          page: page,
          security: '<?php echo wp_create_nonce("search_category_posts"); ?>'
      }
      jQuery.post(ajaxurl,data,function(response){
          jQuery("div.category_search_content").append(response);
          jQuery(".ad-loading").css("display", "none");
          jQuery('[data-toggle="tooltip"]').tooltip();
          jQuery(".ribbon-featured").each(function() {
              var thisText = jQuery(this).text();
              jQuery(this).html("");
              jQuery(this).append(
                  "<div class='ribbon-start'></div>" +
                  "<div class='ribbon-content'>" + thisText + "</div>" +
                  "<div class='ribbon-end'>" +
                      "<figure class='ribbon-shadow'></figure>" +
                  "</div>"
              );
          });
      });
    });
    </script>
<?php } ?>
  </div>
<?php } ?>
</div>
<div class="loading search-loading"><div class="loader-show"></div></div>
<div class="category_search_content">
	<?php
	woocommerce_product_loop_start();

	if ( wc_get_loop_prop( 'total' ) ) {
		while ( have_posts() ) {
			the_post();

			/**
			 * Hook: woocommerce_shop_loop.
			 *
			 * @hooked WC_Structured_Data::generate_product_data() - 10
			 */
			do_action( 'woocommerce_shop_loop' );

			wc_get_template_part( 'content', 'product' );
		}
	}

	woocommerce_product_loop_end();
	/**
	 * Hook: woocommerce_after_shop_loop.
	 *
	 * @hooked woocommerce_pagination - 10
	 */
	do_action( 'woocommerce_after_shop_loop' );
} else {
	/**
	 * Hook: woocommerce_no_products_found.
	 *
	 * @hooked wc_no_products_found - 10
	 */
	do_action( 'woocommerce_no_products_found' );
}
/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );
?>

</div>

</div>


<?php
//show category description
$term_object = get_queried_object();
if($term_object->description && get_theme_mod( 'charsoogh_cat_desc_show') != 'no'){
?>
<div class="container">
  <div class="charsoogh-category-description">
      <div class="title"><?php echo $term_object->name; ?></div>
      <div class="description"><?php echo $term_object->description; ?></div>
  </div>
</div>
<?php } ?>

</section>
</main>
<?php
if(empty(get_theme_mod( 'charsoogh_adv_search_type')) || get_theme_mod( 'charsoogh_adv_search_type') == 'sidebar'){
  get_template_part('template/archive/sidebar-filter');
}
?>
  </div>
<?php
get_footer( 'shop' );
