<!-- Report Ad Modal -->
<div class="modal fade" id="report_ads" tabindex="-1" role="dialog" aria-labelledby="report_ads" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="loading"><div class="loader-show"></div></div>
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalCenterTitle"><?php _e('Report an ad problem' , 'charsoogh'); ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <label for="report_list"><?php _e('Default Reasons:' , 'charsoogh'); ?></label>
        <?php
        global $post;
        include_once(get_template_directory() . '/includes/models/charsoogh_ads_posts.php');
        $charsoogh_posts = new charsoogh_posts();
        $result = $charsoogh_posts->getReportFields();
        ?>
        <input name="ad_id" id="ad_id" type="hidden" value="<?php echo $post->ID; ?>" />
        <select class="form-control" id="report_list">
          <option value="none" selected><?php _e('-- Choose the reason for the report --' , 'charsoogh'); ?></option>
          <?php foreach ($result as $report_value): ?>
            <option value="<?php echo __($report_value , 'charsoogh'); ?>"><?php echo __($report_value , 'charsoogh'); ?></option>
          <?php endforeach; ?>
          <option value="other"><?php _e('Other reasons ...' , 'charsoogh'); ?></option>
        </select>
        <section class="form-control" id="report_text">
          <textarea name="report_reason" id="report_reason" placeholder="<?php _e('Enter your reason here' , 'charsoogh'); ?>" rows="3"></textarea>
        </section>
          <div class="report_result"></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary small" data-dismiss="modal"><?php _e('Cancel' , 'charsoogh'); ?></button>
        <button type="button" class="btn btn-danger small send_report"><?php _e('Send Report' , 'charsoogh'); ?></button>
      </div>

      <?php
      add_action('wp_footer',function(){
          ?>
          <script>
              var ajaxurl = '<?php echo admin_url("admin-ajax.php") ?>';
              var selectedReport = jQuery('#report_list option:selected').val();
              var report_reason;
              jQuery('#report_text').hide();
              jQuery("#report_list").change(function() {
                  selectedReport = jQuery(this).children("option:selected").val();
                  if(selectedReport == 'other'){jQuery('#report_text').show();}else{jQuery('#report_text').hide();}
              });
          </script>
          <?php
      });
      add_action('wp_footer','wp_ajax_report');
      add_action('admin_footer','wp_ajax_report');
      function wp_ajax_report(){
          ?>
          <script>
          jQuery(".send_report").click(function(){
                  report_reason = jQuery('#report_reason').val();
                  var adID = jQuery("#ad_id").val();
                  jQuery("#report_ads .loading").css("display", "block");
                  var data = {
                      action: 'report_action',
                      report: selectedReport,
                      reportReason: report_reason,
                      adID: adID
                  }
                    jQuery.post(ajaxurl,data,function(response){
                        jQuery(".report_result").html(response);
                    });
                });
          </script>
          <?php } ?>
    </div>
  </div>
</div>
