<!DOCTYPE html>
<!-- Design by Tik4.com -->
<html <?php language_attributes(); ?>>
  <head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="author" content="Tik4">
  	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
  	<meta http-equiv="X-UA-Compatible" content="IE=edge">
  	<meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="<?php bloginfo('stylesheet_url');?>" type="text/css" media="screen">
    <link rel="shortcut icon" type="image/png" href="<?php if (get_theme_mod( 'charsoogh_favicon' )) : echo get_theme_mod( 'charsoogh_favicon'); else: echo IMAGES . '/favicon.png'; endif; ?>"/>
    <link rel="apple-touch-icon" href="<?php if (get_theme_mod( 'charsoogh_favicon' )) : echo get_theme_mod( 'charsoogh_favicon'); else: echo IMAGES . '/favicon.png'; endif; ?>" />
    <?php
    if(is_singular( array( 'post', 'product' ) )):
    $image = get_the_post_thumbnail_url(get_the_ID(),'full');
    else:
    if (get_theme_mod( 'charsoogh_favicon' )) : $image = get_theme_mod( 'charsoogh_favicon');else: $image = IMAGES . '/favicon.png';endif;
    endif;
    ?>
    <meta property="og:image" content="<?php echo $image; ?>">
    <meta name="twitter:image" content="<?php echo $image; ?>">
    <?php wp_head(); ?>
    <?php get_template_part('includes/style-options'); ?>
  </head>
<body <?php body_class('woocommerce-page'); ?>>
  <?php wp_body_open(); ?>
    <div class="page home-page">
        <header class="hero">
            <div class="hero-wrapper">
                <div class="secondary-navigation">
                    <div class="container">
                      <nav class="navbar-expand-lg">
                        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#top-navbar" aria-controls="top-navbar" aria-expanded="false" aria-label="Toggle navigation">
                            <span class="navbar-toggler-icon"><i class="fa fa-bars" aria-hidden="true"></i></span>
                        </button>
                      <?php get_template_part('template/city-search'); ?>
                      <div class="collapsed navbar-collapse collapse" id="top-navbar">
                        <ul class="<?php if ( is_rtl() ): echo 'right'; else: echo 'left'; endif; ?>">
                          <?php if(get_theme_mod( 'charsoogh_user_menu_show' ) != 'no'): ?>
                            <?php if (!is_user_logged_in() ) : ?>
                            <li>
                                <a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>">
                                    <i class="fa fa-sign-in"></i> <?php _e('Login / Register' , 'charsoogh'); ?>
                                </a>
                            </li>
                          <?php
                            else:
                            global $current_user;
                            wp_get_current_user();
                            $current_user = wp_get_current_user();
                             ?>
                             <li class="user-account" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                               <a href="#">
                               <i class="fa fa-user" aria-hidden="true"></i> <?php _e('Welcome' , 'charsoogh'); ?> <?php echo $current_user->display_name; ?>
                               </a>
                             </li>
                             <ul class="user-account-menu dropdown-menu" aria-labelledby="sign_in">
                               <?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) : ?>
                                           <li class="<?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
                                             <a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>
                                           </li>
                                         <?php endforeach; ?>
                             </ul>
                          <?php endif; ?>
                          <?php endif; ?>
                          <?php if(get_theme_mod( 'charsoogh_favorite_button_show' ) != 'no'): ?>
                            <li>
                              <?php if (get_theme_mod( 'charsoogh_bookmark_page' )) : $bookmark_page_id = get_theme_mod( 'charsoogh_bookmark_page'); else: $bookmark_page_id = get_site_option( 'bookmark_page_id' ); endif; ?>
                                <a href="<?php echo esc_url( get_page_link( $bookmark_page_id ) ); ?>">
                                    <i class="fa fa-bookmark"></i> <?php _e('Favorites' , 'charsoogh'); ?>
                                </a>
                            </li>
                          <?php endif; ?>
                          <?php if(get_option('membership_plan_activation' , 'off') == 'on'){ ?>
                          <li>
                            <?php
                            if (!get_theme_mod( 'charsoogh_plans_page' ) && empty(get_theme_mod( 'charsoogh_plans_page' ))) :
                            $plan_page = get_site_option('plans_page_id');
                          else:
                            $plan_page = get_theme_mod( 'charsoogh_plans_page' );
                          endif;
                             ?>
                              <a href="<?php echo esc_url( get_page_link( $plan_page ) ); ?>">
                                  <i class="fa fa-bolt"></i>  <?php _e('Buy Membership Plan' , 'charsoogh'); ?>
                              </a>
                          </li>
                          <?php } ?>
                          <?php wp_nav_menu_no_ul(); ?>
                        </ul>
                        </div>
                        </nav>
                    </div>
                </div>
                <?php
                $header_style = get_theme_mod( 'charsoogh_header_style' , 'header_style1');
                get_template_part( 'template/header/' . $header_style );
                ?>
                <?php if (is_home() &&  get_theme_mod( 'charsoogh_general_sub_title_show') != 'no' || is_page_template('page-elementor.php') ) : ?>
                <div class="page-title">
                    <div class="container">
                        <div class="center website_header_slogan">
                          <?php if(!empty(get_theme_mod( 'charsoogh_general_sub_title'))){echo get_theme_mod( 'charsoogh_general_sub_title'); } else{echo __('Free requirements, buying ads, new and used secondhand sales' , 'charsoogh');}; ?>
                        </div>
                    </div>
                </div>
              <?php endif; ?>
                <?php if(!is_home() && !is_search() && !is_page_template('page-elementor.php')){ ?><div class="collapse" id="collapseMainSearchForm"><?php } ?>
                <?php get_template_part('searchform'); ?>
                <?php if(!is_home() && !is_search() && !is_page_template('page-elementor.php')){ ?></div><?php } ?>
                <div class="background">
                    <div class="background-image original-size">
                        <img src="<?php if (get_theme_mod( 'charsoogh_general_bg' )) : echo get_theme_mod( 'charsoogh_general_bg'); else: echo get_template_directory_uri().'/assets/img/hero-background-icons.jpg'; endif; ?>" alt="<?php echo get_theme_mod('charsoogh_main_general_title'); ?>">
                    </div>
                </div>
              <?php if(is_singular() && !is_page_template('page-elementor.php')){ ?>
                <?php while ( have_posts() ) : the_post(); ?>
                <div class="page-title">
                    <div class="container clearfix">
                        <div class="<?php if ( is_rtl() ): echo 'float-right'; else: echo 'float-left'; endif; ?> float-xs-none">
                            <h1><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h1>
                            <?php if(is_singular('product')){ ?>
                            <?php if(get_the_terms( $post->ID, 'city_categories')){ ?>
                              <h4 class="location">
                                <?php
                                $terms = wp_get_post_terms( $post->ID, 'city_categories', array( 'order' => 'DESC') );
                                if(is_rtl()):
                                $sep = ' <i class="fa fa-angle-left" aria-hidden="true"></i> ';
                                else:
                                $sep = ' <i class="fa fa-angle-right" aria-hidden="true"></i> ';
                                endif;
                                foreach ( $terms as $term ) {
                                  $url = get_term_link($term->slug, 'city_categories');
                                  if ($term->parent == 0){echo "<a href='{$url}'>{$term->name}</a>";}
                                }
                                foreach ( $terms as $term ) {
                                  $url = get_term_link($term->slug, 'city_categories');
                                  if ($term->parent != 0){echo $sep . "<a href='{$url}'>{$term->name}</a>";}
                                }
                                ?>
                              </h4>
                          <?php } } if(is_singular('post')){?>
                            <h4 id="blog_category"><i class="fa fa-bookmark-o"></i> <?php the_category(' , '); ?></h4>
                            <span id="blog_information"><i class="fa fa-calendar-o"></i> <?php the_time('j M Y') ?></span>
                            <?php if (get_theme_mod( 'charsoogh_visit_single_blog_show') != 'no') : ?>
                            <span id="blog_information"><i class="fa fa-pie-chart" aria-hidden="true"></i> <?php echo getPostViews(get_the_ID()); ?></span>
                            <?php endif; ?>
                          <?php } ?>
                        </div>
                        <?php
                        $author_id = $post->post_author;
                        $current_user = wp_get_current_user();
                        if(is_singular('product') && get_post_status( $post->ID ) == 'publish'){
                          ?>
                        <div class="<?php if(is_rtl()): echo 'float-left'; else: echo 'float-right'; endif; ?> float-xs-none price">
                            <div class="number"><?php woocommerce_template_loop_price(); ?></div>
                            <?php if (get_theme_mod( 'charsoogh_ad_number') != 'no') : ?>
                            <div class="id opacity-50">
                                <strong><?php _e('Ad Number:' , 'charsoogh'); ?> </strong> <?php echo $post->ID; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                      <?php }elseif(is_singular('product') && get_post_status( $post->ID ) != 'publish' && $author_id == $current_user->ID){ ?>
                        <div class="<?php if(is_rtl()): echo 'float-left'; else: echo 'float-right'; endif; ?> float-xs-none price">
                            <div class="number"><?php woocommerce_template_loop_price(); ?></div>
                            <div class="id opacity-50">
                              <?php if(get_post_status( $post->ID ) == 'expired'){ ?>
                                <strong style="color: red"><?php _e('Ad expired' , 'charsoogh'); ?></strong>
                              <?php }else{ ?>
                                <strong style="color: red"><?php _e('Pending management approval' , 'charsoogh'); ?></strong>
                              <?php } ?>
                            </div>
                        </div>
                      <?php } ?>
                    </div>
                </div>
                <div class="background">
                    <div class="background-image original-size">
                        <img src="<?php if (get_theme_mod( 'charsoogh_general_bg' )) : echo get_theme_mod( 'charsoogh_general_bg'); else: echo get_template_directory_uri().'/assets/img/hero-background-icons.jpg'; endif; ?>" alt="<?php echo get_theme_mod('charsoogh_main_general_title'); ?>">
                    </div>
                </div>
                <?php endwhile; ?>
              <?php } ?>
              <?php if(is_category() || is_product_category() && !is_search()){ ?>
                <div class="page-title">
                    <div class="container clearfix">
                        <div class="<?php if ( is_rtl() ): echo 'float-right'; else: echo 'float-left'; endif; ?> float-xs-none">
                            <h1><?php wp_title(''); ?></h1>
                          </div>
                        </div>
                      </div>
              <?php } ?>
            </div>
        </header>
