<?php
/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 8.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<?php
$register_type = get_option('register_type');
if($register_type != 'email' && $register_type != ''){ ?>

<div class="u-columns row" id="customer_login">
	<div class="col-md-6 offset-md-3 col-sm-12 col-xs-12 col-register-modal">
		<div class="section-title clearfix">
				<h2><?php _e('Login / Register' , 'charsoogh'); ?></h2>
		</div>
		<form class="woocommerce-form woocommerce-form-register register">
			<div class="loading"><div class="loader-show"></div></div>
			<div class="alert alert-warning" role="alert">
			 <p><?php _e('Registration is only possible with a mobile number.' , 'charsoogh'); ?></p>
			</div>
			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide phone_input">
				<label for="reg_phone"><?php _e( 'Phone Number', 'charsoogh' ); ?>&nbsp;<span class="required">*</span></label>
				<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="phone" id="reg_phone" pattern="[0-9]*" placeholder="۰۹۱۲۰۰۰۰۰۰۰" required /><?php // @codingStandardsIgnoreLine ?>
				<p class="user_error_show"></p>
			
			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
			<div class="register-result"></div>
			</p>
			<p class="woocommerce-FormRow form-row register_btn_show">
				<button type="submit" class="woocommerce-Button button charsoogh_register" name="register"><?php _e('Login / Register' , 'charsoogh'); ?></button>
			</p>
			<div class="final-register-result"></div>
		</form>
	</div>
</div>
<?php add_action('wp_footer',function(){ ?>
		<script>
				var ajaxurl = '<?php echo admin_url("admin-ajax.php") ?>';
		</script>
		<?php
});

if(!function_exists('wp_ajax_register')){
add_action('wp_footer','wp_ajax_register');
add_action('admin_footer','wp_ajax_register');
function wp_ajax_register(){
		?>
		<script>
		var faToEnDigits = function (input) {
	if (input == undefined)
			return;
	var returnModel = "", symbolMap = {
			'۱': '1',
			'۲': '2',
			'۳': '3',
			'۴': '4',
			'۵': '5',
			'۶': '6',
			'۷': '7',
			'۸': '8',
			'۹': '9',
			'۰': '0'
	};
	input = input.toString();
	for (var i = 0; i < input.length; i++)
			if (symbolMap[input[i]])
					returnModel += symbolMap[input[i]];
			else
					returnModel += input[i];
	returnModel = returnModel.replace(/\D/g,'');
	return returnModel;
}

		jQuery("#customer_login .loading").css("display", "block");
				jQuery(document).ready(function($) {
					jQuery("#reg_phone").keyup(function(){
							var english_num = jQuery("#reg_phone").val();
							english_num = faToEnDigits(english_num);
							jQuery("#reg_phone").val(english_num);
							jQuery("#reg_phone").trigger('mask');
						});
				 jQuery("#reg_phone").mask("09999999999");
					jQuery("#reg_phone").on("blur", function() {
	        var last = jQuery(this).val().substr( jQuery(this).val().indexOf("-") + 1 );
	        if( last.length == 5 ) {
	            var move = jQuery(this).val().substr( jQuery(this).val().indexOf("-") + 1, 1 );
	            var lastfour = last.substr(1,4);
	            var first = jQuery(this).val().substr( 0, 9 );
	            jQuery(this).val( first + move + '-' + lastfour );
	        }
	    });
					jQuery(".charsoogh_register_code").remove();
					jQuery("#customer_login .loading").css("display", "none");
					// Send Code (First Time)
					jQuery(".charsoogh_register").click(function(event){
						var phone = jQuery("#reg_phone").val();
						if(phone == ''){
							jQuery("#reg_phone").css('border' , '1px solid red');
							event.preventDefault();
							return false;
						}
						 event.preventDefault();
						 jQuery("#customer_login .loading").css("display", "block");
						var number = jQuery("#reg_phone").val();
								var data = {
										action: 'register_action',
										number: number
								}
								jQuery.post(ajaxurl,data,function(response){
										jQuery(".register-result").html(response);
										jQuery("#customer_login .loading").css("display", "none");
								});
						});


						jQuery(document).on('click' , ".charsoogh_register_code", function(event){
							event.preventDefault();
							jQuery("#customer_login .loading").css("display", "block");
							var number = jQuery("#reg_phone").val();
							var code = jQuery("#code_recieve").val();
							var code_generate = jQuery("#code_generate").val();
							var exist = jQuery("#register_exist").val();
									var data = {
											action: 'registerCode_action',
											number: number,
											code: code,
											code_generate: code_generate,
											exist: exist
									}
									jQuery.post(ajaxurl,data,function(response){
										if (response == 'loggedin'){
		                    location.reload();
		                }else{
											jQuery(".final-register-result").html(response);
											jQuery("#customer_login .loading").css("display", "none");
										}
									});
							});

							// Send Code (Second Time)
							jQuery(document).on("click", '.charsoogh_resend_code', function(event) {
								 jQuery("#customer_login .loading").css("display", "block");
								var number = jQuery("#register_number").val();
										var data = {
												action: 'register_action',
												number: number
										}
										jQuery.post(ajaxurl,data,function(response){
												jQuery(".register-result").html(response);
												jQuery("#customer_login .loading").css("display", "none");
										});
								});

							jQuery(document).on('click' , ".charsoogh_register_change", function(event){
								location.reload();
								});
				});
		</script>
		<?php } ?>
	<?php } // end function exist ?>
<?php }else{ ?>

<?php	do_action( 'woocommerce_before_customer_login_form' ); ?>

	<div class="u-columns row" id="customer_login">

		<div class="u-column1 col-md-6 col-sm-12 col-xs-12">

					<div class="section-title clearfix">
							<h2><?php _e( 'Login', 'charsoogh' ); ?></h2>
					</div>

			<form class="woocommerce-form woocommerce-form-login login" method="post">

				<?php do_action( 'woocommerce_login_form_start' ); ?>

				<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
					<label for="username"><?php _e( 'Email or Phone number', 'charsoogh' ); ?>&nbsp;<span class="required">*</span></label>
					<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="username" required autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
				</p>
				<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
					<label for="password"><?php _e( 'Password', 'charsoogh' ); ?>&nbsp;<span class="required">*</span></label>
					<input class="woocommerce-Input woocommerce-Input--text input-text" type="password" name="password" id="password" autocomplete="current-password" required />
				</p>

				<?php do_action( 'woocommerce_login_form' ); ?>

				<p class="form-row">
					<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
					<button type="submit" class="woocommerce-Button button" name="login" value="<?php esc_attr_e( 'Login', 'charsoogh' ); ?>"><?php _e( 'Login', 'charsoogh' ); ?></button>
					<label class="woocommerce-form__label woocommerce-form__label-for-checkbox inline">
						<input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /> <span><?php _e( 'Remember me', 'charsoogh' ); ?></span>
					</label>
				</p>
				<p class="woocommerce-LostPassword lost_password">
					<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php _e( 'Lost your password?', 'charsoogh' ); ?></a>
				</p>

				<?php do_action( 'woocommerce_login_form_end' ); ?>

			</form>

		</div>

		<div class="u-column2 col-md-6 col-sm-12 col-xs-12">
			<div class="section-title clearfix">
					<h2><?php _e( 'Register', 'charsoogh' ); ?></h2>
			</div>


			<form method="post" class="woocommerce-form woocommerce-form-register register" <?php do_action( 'woocommerce_register_form_tag' ); ?> >
				<div class="loading" style="height: 100%;top: 0;"><div class="loader-show"></div></div>
				<?php do_action( 'woocommerce_register_form_start' ); ?>

				<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
					<label for="reg_email"><?php _e( 'Email address', 'charsoogh' ); ?>&nbsp;<span class="required">*</span></label>
					<input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" autocomplete="email" required value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
				</p>
				<p class="form-row form-row-wide">
							 <label for="reg_billing_phone"><?php _e( 'Phone Number', 'charsoogh' ); ?><span class="required">*</span></label>
							 <input type="text" class="input-text" name="billing_phone" id="reg_billing_phone" pattern="[0-9]*" value="<?php esc_attr_e( @$_POST['billing_phone'] ); ?>" required />
							 <p class="user_error_show"></p>
				</p>
					<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
						<label for="reg_password"><?php _e( 'Password', 'charsoogh' ); ?>&nbsp;<span class="required">*</span></label>
						<input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" id="reg_password" autocomplete="new-password" required />
					</p>

				<?php do_action( 'woocommerce_register_form' ); ?>

				<p class="woocommerce-FormRow form-row">
					<?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
					<button type="submit" class="woocommerce-Button button charsoogh_register" name="register" value="<?php esc_attr_e( 'Register', 'charsoogh' ); ?>"><?php _e( 'Register', 'charsoogh' ); ?></button>
				</p>
				<div class="final-register-result"></div>
				<?php do_action( 'woocommerce_register_form_end' ); ?>

			</form>

		</div>

	</div>
	<?php
	add_action('wp_footer',function(){
			?>
			<script>
					var ajaxurl = '<?php echo admin_url("admin-ajax.php") ?>';
			</script>
			<?php
	});
	add_action('wp_footer','wp_ajax_register');
	add_action('admin_footer','wp_ajax_register');
	function wp_ajax_register(){
			?>
			<script>
			jQuery(document).ready(function($) {

				var faToEnDigits = function (input) {
			if (input == undefined)
					return;
			var returnModel = "", symbolMap = {
					'۱': '1',
					'۲': '2',
					'۳': '3',
					'۴': '4',
					'۵': '5',
					'۶': '6',
					'۷': '7',
					'۸': '8',
					'۹': '9',
					'۰': '0'
			};
			input = input.toString();
			for (var i = 0; i < input.length; i++)
					if (symbolMap[input[i]])
							returnModel += symbolMap[input[i]];
					else
							returnModel += input[i];
			returnModel = returnModel.replace(/\D/g,'');
			return returnModel;
		}

		jQuery("#reg_billing_phone").keyup(function(){
				var english_num = jQuery("#reg_billing_phone").val();
				english_num = faToEnDigits(english_num);
				jQuery("#reg_billing_phone").val(english_num);
				jQuery("#reg_billing_phone").trigger('mask');
			});
	 jQuery("#reg_billing_phone").mask("09999999999");

							jQuery(document).on('click' , ".charsoogh_register", function(event){
								event.preventDefault();
								jQuery("#customer_login .loading").css("display", "block");
								var number = jQuery("#reg_billing_phone").val();
								var email = jQuery("#reg_email").val();
								if(!jQuery.isNumeric(number)){
									jQuery("#customer_login .loading").css("display", "none");
									jQuery('.user_error_show').text('<?php _e('Please Enter Valid phone number' , 'charsoogh'); ?>');
									return false;
								}
								if(number.length == 0 || email.length == 0){
									jQuery("#customer_login .loading").css("display", "none");
									jQuery('.user_error_show').text('<?php _e('Please Enter Valid phone number' , 'charsoogh'); ?>');
									return false;
								}
								var password = jQuery("#reg_password").val();
										var data = {
												action: 'register_action',
												number: number,
												email: email,
												password: password,
										}
										jQuery.post(ajaxurl,data,function(response){
											if (response == 'loggedin'){
			                    location.reload();
			                }else{
												jQuery(".final-register-result").html(response);
												jQuery("#customer_login .loading").css("display", "none");
											}

										});
								});
					});
			</script>
			<?php } ?>
<?php }
