<?php
/**
 * Edit account form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-edit-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 7.5.0
 */

defined( 'ABSPATH' ) || exit;
$user_id = get_current_user_id();
do_action( 'woocommerce_before_edit_account_form' ); ?>

<form class="woocommerce-EditAccountForm edit-account" action="" method="post" <?php do_action( 'woocommerce_edit_account_form_tag' ); ?> >

	<?php do_action( 'woocommerce_edit_account_form_start' ); ?>

	<p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first">
		<label for="account_first_name"><?php _e( 'First name', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
		<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="account_first_name" id="account_first_name" autocomplete="given-name" value="<?php echo esc_attr( $user->first_name ); ?>" />
	</p>
	<p class="woocommerce-form-row woocommerce-form-row--last form-row form-row-last">
		<label for="account_last_name"><?php _e( 'Last name', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
		<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="account_last_name" id="account_last_name" autocomplete="family-name" value="<?php echo esc_attr( $user->last_name ); ?>" />
	</p>
	<div class="clear"></div>

	<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
		<label for="account_display_name"><?php _e( 'Display name', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
		<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="account_display_name" id="account_display_name" value="<?php echo esc_attr( $user->display_name ); ?>" /> <span><em><?php _e( 'This will be how your name will be displayed in the account section and in reviews', 'woocommerce' ); ?></em></span>
	</p>
	<div class="clear"></div>

	<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
		<label for="account_email"><?php _e( 'Email address', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
		<input type="email" class="woocommerce-Input woocommerce-Input--email input-text" name="account_email" id="account_email" autocomplete="email" value="<?php echo esc_attr( $user->user_email ); ?>" />
	</p>

	<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
	 <label for="user_address"><?php _e( 'Address', 'charsoogh' ); ?></label>
	 <input type="text" class="woocommerce-Input woocommerce-Input--address input-text" name="user_address" id="user_address" value="<?php echo esc_attr( $user->user_address ); ?>" />
	 <span><em><?php _e( 'The address entered in the user profile', 'charsoogh' ); ?></em></span>
 </p>

	 <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
		 <label for="user_description"><?php _e( 'Description', 'charsoogh' ); ?></label>
		 <textarea name="user_description" id="user_description"><?php echo get_user_meta( $user_id, 'user_description' , true ); ?></textarea>
		 <span><em><?php _e( 'Displayed descriptions in the user profile', 'charsoogh' ); ?></em></span>
	 </p>

	 <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide profile_avatar">
		 <img id="avatar_preview" src="#" style="display:none;z-index:2" />
		 <?php
			$attachment_id = get_user_meta( $user_id, 'user_avatar', true );
			if ( $attachment_id ) {
					$original_image_url = wp_get_attachment_url( $attachment_id );
					echo wp_get_attachment_image( $attachment_id, 'thumbnail');
					echo "<span class='remove_avatar_picture'>x</span>";
			}
			?>
		<label for="user_avatar"><?php _e( 'Profile Picture (Click to upload)', 'charsoogh' ); ?></label>
		<input type="file" class="woocommerce-Input" name="user_avatar" id="user_avatar" value="<?php echo $attachment_id; ?>" accept="image/x-png,image/gif,image/jpeg">
		<input type="hidden" name="image_selected" class="image_selected" value="<?php echo $attachment_id; ?>">
	</p>


		 <section class="row mapSelect" style="display: inline-block;width: 100%;margin-top: 2rem;">
			 <div class="col-md-12 responsive-padding">
			 <label for="user_map_show">
				 <input type="checkbox" name="user_map_show" id="user_map_show" <?php if (esc_attr( $user->user_map_show ) == 'on') { echo 'checked'; } ?>>
				 <?php _e( 'Position on the Map', 'charsoogh' ); ?></label>
				 <div id='map' style='width: 100%; height: 400px; background: url(<?php echo get_template_directory_uri() . "/assets/img/map-overlayer.webp"; ?>) no-repeat;'>
 		      <div class="map-container__layer"></div>
 		      <span class="show-map-btn"><?php _e('Show Map' , 'charsoogh'); ?></span>
 		    </div>
				<?php
				$mapbox_style = get_theme_mod( 'charsoogh_map_style' , 'light-v10');
				$mapbox_marker = get_theme_mod( 'charsoogh_map_marker' , IMAGES ."/" . "icon/marker-icon.png");
				$lat = esc_attr( $user->user_latitude );
				if(!empty($lat) && $lat != false){$lat = $lat;}else{$lat = '35.69912868360278';}
				$long = esc_attr( $user->user_longitude );
				if(!empty($long) && $long != false){$long = $long;}else{$long = '51.40262603759766';}
				?>
				<script>
				jQuery(document).ready(function() {
					jQuery('.show-map-btn').click(function(){
							setTimeout(MapLoad,200);
							jQuery('#map').css('background' , 'transparent');
							jQuery('.show-map-btn').hide();
							});
					function readIMG(input) {
		        if (input.files && input.files[0]) {
		            var reader = new FileReader();
		            reader.onload = function (e) {
									jQuery('#avatar_preview').show();
									jQuery('.remove_avatar_picture').remove();
		                jQuery('#avatar_preview').attr('src', e.target.result);
		            }
		            reader.readAsDataURL(input.files[0]);
		        }
		    }

					if (jQuery('#user_map_show').is(':checked')) {
						jQuery("#map").slideDown();
						}
					jQuery('#user_map_show').on('ifChecked', function (event) {
					    jQuery("#map").slideDown();
						});
						jQuery('#user_map_show').on('ifUnchecked', function (event) {
						   jQuery("#map").slideUp();
							 jQuery(".latitude").val('');
							 jQuery(".longitude").val('');
						});
				jQuery("#user_avatar").change(function (){
			       var fileName = jQuery(this).val();
			       jQuery(".image_selected").val(fileName);
						 readIMG(this);
			     });

					 jQuery(".remove_avatar_picture").click(function(){
						    jQuery('.attachment-thumbnail').remove();
								jQuery(".image_selected").val('');
								jQuery('.remove_avatar_picture').remove();
						});

		function MapLoad(){
				var token ="<?php echo get_option('mapbox_token_key'); ?>";
				<?php if(!empty($lat) && !empty($long)){ ?>
				var map = L.map('map').setView([<?php echo $lat; ?>, <?php echo $long; ?>], 18);
				L.marker(
							 [<?php echo $lat; ?>, <?php echo $long; ?>],
						 {
						icon: new L.DivIcon({
						className: 'l-marker-icon',
						html: '<img class="l-marker-image" src="<?php echo $mapbox_marker; ?>" width="25px" height="41px"/>'+
				 '<span class="l-marker-span"><?php _e('Your Location' , 'charsoogh'); ?></span>',
						iconSize: [25, 41],
						iconAnchor: [25, 41],
						}),
						 riseOnHover: true,
					   draggable: false,
						 autoPan: true,
						}
					).addTo(map);


						L.tileLayer('https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=' + token, {
								maxZoom: 18,
								id: 'mapbox/<?php echo $mapbox_style; ?>',
								tileSize: 512,
    						zoomOffset: -1,
								accessToken: token
						}).addTo(map);
				<?php }else{ ?>
				var map = L.map('map').setView([<?php echo $lat; ?>, <?php echo $long; ?>], 17);
				if (navigator.geolocation) {
					navigator.geolocation.getCurrentPosition(function(position) {
						latit = position.coords.latitude;
						longit = position.coords.longitude;
						// move the map to have the location in its center
						map.panTo(new L.LatLng(latit, longit));
						marker = new L.marker([latit , longit]).addTo(map);
						map.addLayer(marker);
				});
				}
				<?php } ?>
				L.tileLayer('https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=' + token, {
						maxZoom: 18,
						id: 'mapbox/<?php echo $mapbox_style; ?>',
						tileSize: 512,
    				zoomOffset: -1,
						accessToken: token
				}).addTo(map);
				map.addControl( new L.Control.Search({
					url: 'https://nominatim.openstreetmap.org/search?format=json&q={s}',
					jsonpParam: 'json_callback',
					propertyName: 'display_name',
					propertyLoc: ['lat','lon'],
					marker: L.circleMarker([0,0],{radius:30}),
					autoCollapse: true,
					autoType: false,
					minLength: 2
				}) );

				var marker = {};
				function onMapClick(e) {
					if (marker != undefined) {
								map.removeLayer(marker);
					};

					marker = new L.marker(e.latlng, {
						draggable:'true',
						icon: new L.DivIcon({
						className: 'l-marker-icon',
						html: '<img class="l-marker-image" src="<?php echo $mapbox_marker; ?>" width="25px" height="41px"/>'+
				 '<span class="l-marker-span"><?php _e('Your Location' , 'charsoogh'); ?></span>',
						iconSize: [25, 41],
						iconAnchor: [25, 41],
						}),
						 riseOnHover: true,
					   draggable: false,
						 autoPan: true,
					}).addTo(map);
					lat = e.latlng.lat;
					lon = e.latlng.lng;
					jQuery('.latitude').val(lat);
					jQuery('.longitude').val(lon);
					marker.on('dragend', function(event){
						var marker = event.target;
						var position = marker.getLatLng();
						marker.setLatLng(new L.LatLng(position.lat, position.lng),{draggable:'true'});
						map.panTo(new L.LatLng(position.lat, position.lng))
					});
					map.addLayer(marker);
				};
				map.on('click', onMapClick);
			}
				});
				</script>
			 <input type="hidden" name="user_latitude" value="<?php echo $lat; ?>" class="latitude" />
			 <input type="hidden" name="user_longitude" value="<?php echo $long; ?>" class="longitude" />
			 </div>
		 </section>

<?php $register_type = get_option('register_type');
if($register_type == 'email' || $register_type == '' || $register_type == false){ ?>
	<fieldset>
		<legend><?php _e( 'Password change', 'woocommerce' ); ?></legend>

		<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
			<label for="password_current"><?php _e( 'Current password (leave blank to leave unchanged)', 'woocommerce' ); ?></label>
			<input type="password" class="woocommerce-Input woocommerce-Input--password input-text" name="password_current" id="password_current" autocomplete="off" />
		</p>
		<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
			<label for="password_1"><?php _e( 'New password (leave blank to leave unchanged)', 'woocommerce' ); ?></label>
			<input type="password" class="woocommerce-Input woocommerce-Input--password input-text" name="password_1" id="password_1" autocomplete="off" />
		</p>
		<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
			<label for="password_2"><?php _e( 'Confirm new password', 'woocommerce' ); ?></label>
			<input type="password" class="woocommerce-Input woocommerce-Input--password input-text" name="password_2" id="password_2" autocomplete="off" />
		</p>
	</fieldset>
<?php } ?>
	<div class="clear"></div>

	<?php do_action( 'woocommerce_edit_account_form' ); ?>

	<p>
		<?php wp_nonce_field( 'save_account_details', 'save-account-details-nonce' ); ?>
		<button type="submit" class="woocommerce-Button button" name="save_account_details" value="<?php esc_attr_e( 'Save changes', 'woocommerce' ); ?>"><?php _e( 'Save changes', 'woocommerce' ); ?></button>
		<input type="hidden" name="action" value="save_account_details" />
	</p>

	<?php do_action( 'woocommerce_edit_account_form_end' ); ?>
</form>

<?php do_action( 'woocommerce_after_edit_account_form' ); ?>
