<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     5.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$userId = get_current_user_id();
$user_plan = get_user_meta( $userId , 'user_plan' , true );
$amount_left = get_user_meta($userId,'adv_amount',true);
$user_submit = @$user_plan['submit_ad_status'];
$finish_miliseconds = get_user_meta($userId,'plan_finish',true );
$now_miliseconds = round(microtime(true) * 1000);
if($finish_miliseconds == "" || $finish_miliseconds == "false"){
	 $finish_miliseconds = 0 ;
}else{
	 $finish_miliseconds = (float) $finish_miliseconds ;
}
$time = $finish_miliseconds - $now_miliseconds ;
$time = $time / (1000 * 60 * 60 * 24);
$day = ceil($time) ;

if(get_option('membership_plan_activation') == 'on'){
?>
<div class="row user-profile-detail">
		<div class="col-md-4">
			<div class="detail-box">
				<h5><?php echo __('Plan Name' , 'charsoogh'); ?></h5>
			<i class="fa fa-cubes" aria-hidden="true"></i>
			<span>
				<?php
				if($now_miliseconds > $finish_miliseconds){
					echo __('Your Membership plan has Expired' , 'charsoogh');
				}else{
					echo $user_plan['plan_name'];
				}
					?>

			</span>
			</div>
		</div>
		<div class="col-md-4">
			<div class="detail-box">
				<h5><?php echo __('Permitted ads' , 'charsoogh'); ?></h5>
				<i class="fa fa-bullhorn" aria-hidden="true"></i>
				<span>
					<?php
					if($amount_left == "unlimited"){
						echo __('Unlimited' , 'charsoogh');
					}else if($amount_left =="" || $amount_left == 0 || $amount_left== false && $user_submit != 'yes'){
							echo __("You cannot send ads" , "charsoogh");
					}else{
						if($amount_left < 0){
						echo '0 ' . __('Ad' , 'charsoogh');
						}else{
						echo $amount_left . ' ' . __('Ad' , 'charsoogh');
						}
					}
					 ?>
				</span>
			</div>
		</div>
		<div class="col-md-4">
			<div class="detail-box">
				<h5><?php echo __('Days left' , 'charsoogh'); ?></h5>
				<i class="fa fa-calendar-o" aria-hidden="true"></i>
				<span>
					<?php
					if($now_miliseconds > $finish_miliseconds){
						echo __('You have no Plan' , 'charsoogh');
					}else{
						echo $day . ' ' . __('Day' , 'charsoogh');
					}
				 ?>
			</span>
			</div>
		</div>
	</div>
<?php } //Check if Plan is Active ?>
<div class="section-title clearfix">
<h2><?php _e('My Ads' , 'charsoogh'); ?></h2>
</div>

<div class="loading"><div class="loader-show"></div></div>
<section class="block">
	<?php if (get_theme_mod( 'charsoogh_ad_page' )) : $newad_page_id = get_theme_mod( 'charsoogh_ad_page'); else: $newad_page_id = get_site_option( 'newad_page_id' ); endif; ?>
		<a href="<?php echo esc_url( get_page_link( $newad_page_id ) ); ?>" class="add_new_ad_user">
	<button class="btn btn-success <?php if ( is_rtl() ): echo 'float-left'; else: echo 'float-right'; endif; ?> add_new_post_dashboard"><i class="fa fa-plus" aria-hidden="true"></i>
<?php if (get_theme_mod( 'charsoogh_submit_btn_title' )) : echo get_theme_mod( 'charsoogh_submit_btn_title'); else: echo __('Free ad submission' , 'charsoogh'); endif; ?>
	</button>
	</a>
		<div class="container p-0">

				<div class="row items">
					<div class="bookmark-list row">
						<?php
						$paged = 1;
						$current_user = wp_get_current_user();
				    $args = array('author' => $current_user->ID, 'post_status' => 'any' ,'post_type' => 'product', 'posts_per_page' => 10 ,
						'paged' => $paged , 'no_paging' => false ,'orderby' => 'post_date' , 'meta_query' => array(
                        array(
                          'key' => '_is_deleted',
                          'compare' => 'NOT EXISTS'
                            )
                        ));
				 	 $wp_query = new WP_Query($args);
						?>
						<?php if ( $wp_query->have_posts() ) : ?>
						<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
						<?php wc_get_template_part( 'content', 'user-product' ); ?>
						<?php endwhile; ?>
						<?php else: ?>
						<p><?php _e('Sorry, the ad is not available.' , 'charsoogh'); ?></p>
						<?php endif; ?>
					</div>
					<?php if ( $wp_query->have_posts() ) : ?>
					<?php if($wp_query->max_num_pages != $paged): ?>
					<div class="center ad-load-more">
					<div class="ad-loading"><div class="ad-loader-show"></div></div>
					<div class="btn btn-primary btn-framed btn-rounded loadmore">
					<?php if (get_theme_mod( 'charsoogh_ad_more_text' )) : echo get_theme_mod( 'charsoogh_ad_more_text'); else: echo __('More Ad...' , 'charsoogh'); endif; ?>
					</div>
					</div>
					<?php endif; ?>
					<?php endif; ?>
<?php
add_action('wp_footer',function(){
	?>
	<script>
			var ajaxurl = '<?php echo admin_url("admin-ajax.php") ?>';
	</script>
	<?php
});
add_action('wp_footer','wp_ajax_newad');
add_action('admin_footer','wp_ajax_newad');
function wp_ajax_newad(){
	?>
	<script>
			jQuery(document).ready(function($) {
							var page = 2;
							jQuery(function($) {
								 $('body').on('click', '.loadmore', function() {
									 jQuery(".ad-loading").css("display", "block");
									 jQuery(".loadmore").hide();
										 var data = {
												 'action': 'user_load_posts_by_ajax',
												 'page': page,
												 'security': '<?php echo wp_create_nonce("user_load_more_posts"); ?>'
										 };

										 $.post(ajaxurl, data, function(response) {
												 $('.bookmark-list').append(response);
												 page++;
												 $('[data-toggle="tooltip"]').tooltip();
												 $(".ribbon-featured").each(function() {
														 var thisText = $(this).text();
														 $(this).html("");
														 $(this).append(
																 "<div class='ribbon-start'></div>" +
																 "<div class='ribbon-content'>" + thisText + "</div>" +
																 "<div class='ribbon-end'>" +
																		 "<figure class='ribbon-shadow'></figure>" +
																 "</div>"
														 );
												 });
												 jQuery(".ad-loading").css("display", "none");
												 jQuery(".loadmore").show();
										 });
								 });
							});
			});
	</script>
	<?php } ?>
				 </div>
		</div>
</section>
<?php


	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_before_my_account' );

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_after_my_account' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
