<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
include_once(get_template_directory() . '/includes/models/premium_posts.php');
$premium_class = new premium_posts();
?>
<li <?php wc_product_class('item'); ?>>
<?php
do_action( 'woocommerce_before_shop_loop_item' );
?>
	<?php if ( $product->is_featured() ) { ?><div class="ribbon-featured"><?php if (get_theme_mod( 'charsoogh_featured_badge_title' )) : echo get_theme_mod( 'charsoogh_featured_badge_title'); else: echo __('Featured' , 'charsoogh'); endif; ?></div><?php } ?>
				<div class="wrapper">
							<div class="image">
								<?php if(get_the_terms( $post->ID, 'city_categories')){ ?>
								<h4 class="location"><?php the_terms( $post->ID, 'city_categories', '', ' <i class="fa fa-angle-left" aria-hidden="true"></i> ', '' ); ?></h4>
							<?php } ?>
									<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="title">
										<?php woocommerce_template_loop_product_thumbnail(); ?>
										 </a>
							</div>
							<?php woocommerce_template_loop_price(); ?>
							<div class="meta">
								<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="title">
									<h2><?php the_title(); ?></h2>
									</a>
									<figure>
										<?php if (empty(get_theme_mod( 'charsoogh_date_type')) || get_theme_mod( 'charsoogh_date_type') == 'advanced') : ?>
											<i class="fa fa-calendar-o"></i><?php echo human_time_diff( get_the_time('U'), current_time('timestamp') ) . __(' Ago' , 'charsoogh'); ?>
										<?php else: ?>
											<i class="fa fa-calendar-o"></i><?php echo get_the_date(); ?>
										<?php endif; ?>
									</figure>
									<figure>
											<i class="fa fa-folder-open-o"></i><?php the_terms( $post->ID, 'product_cat', '', " ", '' );?>
									</figure>
									<figure>
											<i class="fa fa-bar-chart" aria-hidden="true"></i><?php echo getPostViews(get_the_ID()); ?>
									</figure>
									<?php
									$terms = wp_get_post_terms($post->ID, 'product_cat');
									if(is_array($terms) && sizeof($terms) > 0){
									$catID = $terms[0]->term_id;
									$result = $premium_class -> getPriceFromCategory($catID);
									if(isset($result['price']) && $result['price'] > 0){
										$check_pay_meta = get_post_meta($post->ID , '_paid_status' , true);
											if($check_pay_meta != 'yes' && get_post_status( $post->ID ) != 'publish'){ ?><a id="not_pay" href="<?php echo 'edit-ad?upgrade=' . get_the_ID(); ?>"><span class="meta_info_span"><?php _e('Awaiting Payment' , 'charsoogh'); ?></span></a>
											<?php
										}
									}
									}
									if ( get_post_status ( $post->ID ) == 'pending' ) { echo '<span class="meta_info_span">'. __('Waiting for review' , 'charsoogh') .'</span>'; }
									elseif ( get_post_status ( $post->ID ) == 'expired' ) {?> <a id="not_pay" href="<?php echo 'edit-ad?upgrade=' . get_the_ID(); ?>"><span class="meta_info_span"><?php _e('Expired' , 'charsoogh'); ?></span></a> <?php }
									 ?>
									<div class="admin-controls">
										<?php if(get_post_status( $post->ID ) == 'publish'){ ?>
											<a href="<?php the_permalink(); ?>" target="_blank">
													<i class="fa fa-eye" aria-hidden="true"></i> <?php _e('View Ad' , 'charsoogh'); ?>
											</a>
										<?php } ?>
											<?php if(get_post_status ( $post->ID ) != 'expired' ){ ?>
											<a href="<?php echo 'edit-ad?adid=' . get_the_ID(); ?>">
													<i class="fa fa-pencil"></i> <?php _e('Edit Ad' , 'charsoogh'); ?>
											</a>
											<?php } ?>
											<a href="<?php echo 'edit-ad?upgrade=' . get_the_ID(); ?>">
													<i class="fa fa-sort-amount-asc"></i> <?php _e('Upgrade Ad' , 'charsoogh'); ?>
											</a>
											<a href="<?php echo 'edit-ad?delete=' . get_the_ID(); ?>" onclick="deleteConfirm()">
											<i class="fa fa-times" aria-hidden="true"></i> <?php _e('Delete Ad' , 'charsoogh'); ?>
											</a>
										</div>
									  <?php get_template_part('includes/user-bookmark'); ?>
							</div>
							<!--end meta-->
							<!--end description-->
					</div>

<?php woocommerce_template_loop_product_link_close(); ?>
</li>
<?php if(get_post_meta( $post->ID , '_admin_review', true ) && !empty(get_post_meta( $post->ID , '_admin_review', true ))): ?>
<section class="admin_ad_notice">
	<b><i class="fa fa-info-circle" aria-hidden="true"></i> <?php _e('Admin Message:' , 'charsoogh'); ?></b>
	<?php echo get_post_meta( $post->ID , '_admin_review', true ); ?>
</section>
<?php endif; ?>
