<?php if (get_theme_mod( 'charsoogh_blog_show') != 'no') : ?>
<section class="index-blog blog-block">
    <div class="container">
      <div class="<?php if (get_theme_mod( 'charsoogh_blog_title_style' )) : echo get_theme_mod( 'charsoogh_blog_title_style'); else: echo 'section-title'; endif; ?> clearfix">
      <h2><?php if (get_theme_mod( 'charsoogh_blog_title' )) : echo get_theme_mod( 'charsoogh_blog_title'); else: echo __('Blog' , 'charsoogh'); endif; ?></h2>
      </div>

      <div class="row blog-carousel owl-carousel">
        <?php
        $args = array('post_type' => 'post','posts_per_page' => 10);
        $wp_query = new WP_Query($args);
        ?>
        <?php if ( $wp_query->have_posts() ) : ?>
        <?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
        <div class="blog-item">
          <div class="images">
            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
            <?php if(has_post_thumbnail()){the_post_thumbnail('img-260-200');}else{ ?>
            <img src="<?php bloginfo('template_directory'); ?>/assets/img/featured-image-missing.png" alt="<?php _e('No image available' , 'charsoogh'); ?>">
          <?php } ?>
            </a>
          <p class="blog-detail">
            <span>
              <?php if (empty(get_theme_mod( 'charsoogh_blog_date_type')) || get_theme_mod( 'charsoogh_blog_date_type') == 'advanced') : ?>
              <i class="fa fa-calendar-o"></i> <?php echo human_time_diff( get_the_time('U'), current_time('timestamp') ) . __(' Ago' , 'charsoogh'); ?>
              <?php else: ?>
              <i class="fa fa-calendar-o"></i> <?php echo get_the_date(); ?>
              <?php endif; ?>
            </span>
            <span>
              <i class="fa fa-bookmark-o"></i>
              <?php
              $category_array = wp_get_post_categories($post->ID);
              $category_list = array();
              foreach ( $category_array as $categories ) {
                  $category_list[] = get_cat_name( $categories );
              }
              $lister = implode(' / ', $category_list);
              $list_categories = $lister;
              echo $lister ;
          ?>
            </span>
            <?php if (get_theme_mod( 'charsoogh_visit_blog_show') != 'no') : ?>
            <span><i class="fa fa-pie-chart" aria-hidden="true"></i> <?php echo getPostViews(get_the_ID()); ?></span>
            <?php endif; ?>
          </p>
          </div>
          <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
            <h3><?php the_title(); ?></h3>
          </a>
          <div class="blog-meta">
            <?php echo excerpt(17); ?>
          </div>
        </div>
      <?php endwhile; ?>
      <?php else: ?>
      <p><?php _e('Unfortunately, there is no post to show' , 'charsoogh'); ?></p>
      <?php endif; ?>
      </div>
<?php if (get_theme_mod( 'charsoogh_blog_layout' )) : $blog_layout = get_theme_mod( 'charsoogh_blog_layout'); else: $blog_layout = '4'; endif; ?>
<script>
jQuery(document).ready(function($) {jQuery(".blog-carousel").owlCarousel({loop:!1,margin:20,nav:!0,dots:!1,items:<?php echo $blog_layout; ?>,<?php if(is_rtl()): echo 'rtl:!0'; else: echo 'ltr:!0'; endif; ?>,navText:["<i class='fa fa-chevron-left'></i>","<i class='fa fa-chevron-right'></i>"],URLhashListener:!0,responsive:{768:{items:<?php echo $blog_layout; ?>},0:{items:1,center:!1,margin:0,autoWidth:!1}}});});
</script>
    </div>
</section>
<?php endif; ?>
