<?php
/*
Template Name: Full Map
*/
?>
<?php get_header('map'); ?>
<div class="map-full-overlayer"></div>
<?php if(!empty(get_option('map_activation')) && get_option('map_activation') == 'on'){ ?>
<section class="charsoogh-full-map">
  <style>html, body, #fullmap {height: 100%;width: 100%;overflow: hidden;}</style>
  <?php
  add_action('wp_footer',function(){
  	?>
  	<script>
  			var ajaxurl = '<?php echo admin_url("admin-ajax.php") ?>';
  	</script>
  	<?php
  });
  add_action('wp_footer','wp_ajax_newad');
  $args = array('post_type' => 'product' , 'post_status' => 'publish' ,'posts_per_page' => -1 );
  $wp_query = new WP_Query($args);
  if ( $wp_query->have_posts() ) :
   ?>
  <div id="fullmap"></div>
  <?php
  $mapbox_style = get_theme_mod( 'charsoogh_map_style' , 'light-v10');
  $mapbox_marker = get_theme_mod( 'charsoogh_map_marker' , IMAGES ."/" . "icon/marker-icon.png");
  $user_marker = get_theme_mod( 'charsoogh_map_marker' , IMAGES ."/" . "icon/marker-icon.svg");
  $mapbox_zoom = get_theme_mod( 'charsoogh_map_zoom' , '4');
  $lat = get_option('_mapbox_defult_lat');
  if(!empty($lat) && $lat != false){$lat = $lat;}else{$lat = '39.977120098439634';}
  $long = get_option('_mapbox_defult_long');
  if(!empty($long) && $long != false){$long = $long;}else{$long = '31.116367418173862';}
  ?>
  <script>
  jQuery(document).ready(function() {
  var token = "<?php echo get_option('mapbox_token_key'); ?>";
  var map = L.map('fullmap').setView([<?php echo $lat; ?>, <?php echo $long; ?>], <?php echo $mapbox_zoom; ?>);
  if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(function(position) {
      latit = position.coords.latitude;
      longit = position.coords.longitude;
      // move the map to have the location in its center
      map.panTo(new L.LatLng(latit, longit));
      marker = new L.marker([latit , longit], {
        draggable:'true',
        icon: new L.DivIcon({
        className: 'l-marker-icon',
        html: '<img class="l-marker-image" src="<?php echo $user_marker; ?>" width="25px" height="41px"/>'+
     '<span class="l-marker-span"><?php _e('Your Location' , 'charsoogh'); ?></span>',
         iconSize: [25, 41],
         iconAnchor: [25, 41],
        }),
         riseOnHover: true,
         draggable: false,
         autoPan: true,
      }).addTo(map);
      map.addLayer(marker);
  });
  }
  <?php
  while ( $wp_query->have_posts() ) {
  $wp_query->the_post();
  if(get_post_meta($post->ID , '_ad_latitude' , true) && get_post_meta($post->ID , '_ad_longitude' , true)){
     ?>
     L.marker(
            [<?php echo get_post_meta($post->ID , '_ad_latitude' , true); ?>, <?php echo get_post_meta($post->ID , '_ad_longitude' , true); ?>],
          {
         icon: new L.DivIcon({
         className: 'l-marker-icon',
         html: '<img class="l-marker-image" src="<?php echo $mapbox_marker; ?>" width="25px" height="41px"/>'+
      '<span class="l-marker-span"><?php echo wp_trim_words( get_the_title(), 3, '...' ); ?></span>',
          iconSize: [25, 41],
          iconAnchor: [25, 41],
         }),
          riseOnHover: true,
          draggable: false,
          autoPan: true,
         }
       ).on('click', function () {
         load_map_ads(<?php echo $post->ID; ?>);
         jQuery('.map-full-overlayer').fadeIn();
       }).addTo(map);

      <?php } } ?>
  map.addControl(new L.Control.Fullscreen());
      L.tileLayer('https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=' + token, {
          maxZoom: 18,
          minZoom: 5,
          id: 'mapbox/<?php echo $mapbox_style; ?>',
          tileSize: 512,
          zoomOffset: -1,
          accessToken: token
      }).addTo(map);
  });
  </script>


        <script>
        jQuery(document).mouseup(function(e)
        {
            var container = jQuery(".post_show_side");

            // if the target of the click isn't the container nor a descendant of the container
            if (!container.is(e.target) && container.has(e.target).length === 0)
            {
                container.hide();
                jQuery('.map-full-overlayer').fadeOut();
            }
        });
        function load_map_ads(post_id){
          jQuery(".post_show_side .post-content-side").html('');
          jQuery(".post_show_side").animate({width:'toggle'},350);
          jQuery(".post_show_side .ad-loading").css("display", "block");
          // Load Ajax Data
          var data = {
              'action': 'load_full_map_by_ajax',
              'post_id': post_id,
              'security': '<?php echo wp_create_nonce("load_map_posts"); ?>'
          };

          jQuery.post(ajaxurl, data, function(response) {
              jQuery('.post_show_side .post-content-side').html(response);
(function ($) {
  var $doc = $(document);

  /**
   * Slider
   */
  $('.highlight-main').flickity({
    pageDots: false,
    adaptiveHeight: true,
    lazyLoad: true,
    imagesLoaded: true
  });

  /**
   * Thumbnails
   */
  var $thumbnails = $('.highlight-thumbs').flickity({
    asNavFor: '.highlight-main',
    cellSelector: '.carousel-cell',
    contain: true,
    pageDots: false,
    prevNextButtons: false,
    freeScroll: true,
    imagesLoaded: true
  });

  /**
   * Thumbnails Scrollbar
   */
  var $scroll = $thumbnails.find('.carousel-scrollbar');
  var $scrollInner = $scroll.find('.carousel-scrollbar-inner');
  var flkty = $thumbnails.data('flickity');

  // recalculate scrollbar size
  var scrollInnerSize = 0;
  var recalculateScrollSizeTimeout;
  function recalculateScrollSize() {
    clearTimeout(recalculateScrollSizeTimeout);
    recalculateScrollSizeTimeout = setTimeout(function() {
      $scrollInner.width(flkty.size.width * flkty.size.width / flkty.slideableWidth);

      // hide scrollbar if don't needed
      if ( flkty.size.width >= flkty.slideableWidth ) {
        $scroll.addClass('is-hidden');
      } else {
        $scroll.removeClass('is-hidden');
      }

      scrollInnerSize = $scrollInner.width() / $scroll.width();
    }, 155); // flickity has debounce 150ms
  }
  recalculateScrollSize();
  $thumbnails.on( 'ready.flickity change.flickity', recalculateScrollSize);
  $(window).on('ready load resize orientationchange', recalculateScrollSize);

  // set scrollbar position
  $thumbnails.on('scroll.flickity', function(event, progress) {
    $scrollInner.css({
      left: (progress * (1 - scrollInnerSize)) * 100 + '%'
    });
  });
  $thumbnails.flickity('reposition');

  // scrollbar drag event.
  var lastPageX = 0;
  var lastThumbsX = 0;
  function drag(e) {
    e.preventDefault();
    var delta = e.pageX - lastPageX;

    flkty.x = lastThumbsX - (flkty.slideableWidth * delta / flkty.size.width);

    if ( ! flkty.isFreeScrolling ) {
      flkty.animate();
    }
  }
  function stop(e) {
    e.preventDefault();
    $doc.off('mousemove', drag);
    $doc.off('mouseup', stop);

    if ( flkty.options.freeScroll ) {
      flkty.isFreeScrolling = true;
    }

    // set selectedIndex based on where flick will end up
    var index = flkty.dragEndRestingSelect();

    if ( flkty.options.freeScroll && !flkty.options.wrapAround ) {
      // if free-scroll & not wrap around
      // do not free-scroll if going outside of bounding slides
      // so bounding slides can attract slider, and keep it in bounds
      var restingX = flkty.getRestingPosition();
      flkty.isFreeScrolling = -restingX > flkty.slides[0].target &&
        -restingX < flkty.getLastSlide().target;
    }

    flkty.select( index );
  }
  $scrollInner.on('mousedown', function(e) {
    e.preventDefault();

    lastPageX = e.pageX;
    lastThumbsX = flkty.x;

    flkty.isFreeScrolling = true;
    flkty.startAnimation();

    $doc.on('mousemove', drag);
    $doc.on('mouseup', stop);
  });

}(jQuery));
              jQuery(".post_show_side .ad-loading").css("display", "none");
          });
        }
        jQuery('body').on('click', '.post_show_side .close-post-detail', function() {
          jQuery(".post_show_side .ad-loading").fadeOut();
          jQuery(".post_show_side .post-content-side").html('');
          jQuery(".post_show_side").animate({width:'toggle'},350);
          jQuery('.map-full-overlayer').fadeOut();
        });
        </script>
  <div class="post_show_side">
  <i class="fa fa-times close-post-detail" aria-hidden="true"></i>
    <div class="charsoogh-main-content-side-map">
      <div class="ad-loading"><div class="ad-loader-show"></div></div>
      <div class="post-content-side"></div>
    </div>
  </div>
  <?php endif; ?>
</section>
<?php } ?>
<?php get_footer('map'); ?>
