/* charsoogh Extension for Elementor v3.3.2 */

!(function ($) {
	'use strict';

	// Owl Carousel for some Slider or Carousel
	function charsooghOwl(owl) {
		var itemLg = owl.data('item-lg'),
			itemLg = itemLg ? itemLg : 2,
			itemMd = owl.data('item-md'),
			itemMd = itemMd ? itemMd : 2,
			itemSm = owl.data('item-sm'),
			itemSm = itemSm ? itemSm : 1,
			slideIn = owl.data('slide-anim'),
			slideOut = owl.data('slide-anim-out'),
			slideOut = 'none' == slideOut ? false : slideOut,
			slideIn = 'none' == slideIn ? false : slideIn,
			play = owl.data('autoplay') ? true : false,
			pause = owl.data('pause') ? true : false,
			center = owl.data('center') ? true : false,
			nav = owl.data('nav') ? true : false,
			dots = owl.data('dots') ? true : false,
			mouse = owl.data('mouse-drag') ? true : false,
			touch = owl.data('touch-drag') ? true : false,
			loop = owl.data('loop') ? true : false,
			speed = owl.data('speed'),
			speed = speed ? speed : 500,
			delay = owl.data('delay');

		// Initialize carousel
		owl.owlCarousel({
			animateOut: slideOut,
			animateIn: slideIn,
			autoplay: play,
			autoplayHoverPause: pause,
			center: center,
			nav: nav,
			dots: dots,
			mouseDrag: mouse,
			touchDrag: touch,
			loop: loop,
			smartSpeed: speed,
			autoplayTimeout: delay,
			responsive: {
				0: {
					items: itemSm
				},
				600: {
					items: itemMd
				},
				900: {
					items: itemLg
				},
			}
		});
	}

	function addZero(val) {
		if ( val < 10 ) {
			return '0'+val;
		}
		return val;
	}

	function charsooghBrandCarousel($scope, $) {
		$scope.find('.charsoogh-brand-carousel').each(function () {
			charsooghOwl( $(this) );
		});
	}

	function charsooghContentSlider($scope, $) {
		$scope.find('.charsoogh-content-slider').each(function () {
			charsooghOwl( $(this) );
		});
	}

	function charsooghPostsCarousel($scope, $) {
		$scope.find('.charsoogh-posts-carousel').each(function () {
			charsooghOwl( $(this) );
		});
	}

	function charsooghReviewCarousel($scope, $) {
		$scope.find('.charsoogh-review-carousel').each(function () {
			charsooghOwl( $(this) );
		});
	}

	function charsooghAccordion($scope, $) {
		$scope.find('.charsoogh-accordion').each(function () {
			var $this = $(this),
				openF = $this.data('open-first');

			$this.find('.charsoogh-accordion-item').each(function(index, el) {
				var $item = $(this),
					$siblings = $item.siblings('.charsoogh-accordion-item'),
					$header = $item.children('.charsoogh-accordion-header'),
					$body = $item.children('.charsoogh-accordion-body');

				if ( openF && 0 == index ) {
					$body.slideDown(200);
				}

				$header.on('click', function(e) {
					e.stopImmediatePropagation();

					$body.slideToggle(200);
					$siblings.children('.charsoogh-accordion-body').slideUp(200);
					$item.toggleClass('open');
					$siblings.removeClass('open');
				});
			});
		});
	}

	function charsooghBannerSlider($scope, $) {
		$scope.find('.charsoogh-banner-slider').each(function () {
			function doAnimations( elems ) {
				var animEndEv = 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend';

				elems.each(function () {
					var $this = $(this),
						$animationType = $this.data('animation');
						$this.removeClass('charsoogh-anim-invisible');

					$this.addClass($animationType).one(animEndEv, function () {
						$this.removeClass($animationType);
					});
				});
			}

			var $this = $(this),
				play = $this.data('autoplay') ? true : false,
				pause = $this.data('pause') ? true : false,
				nav = $this.data('nav') ? true : false,
				dots = $this.data('dots') ? true : false,
				mouse = $this.data('mouse-drag') ? true : false,
				touch = $this.data('touch-drag') ? true : false,
				loop = $this.data('loop') ? true : false,
				partAnim = $this.data('part-anim'),
				speed = $this.data('speed'),
				speed = speed ? speed : 500,
				delay = $this.data('delay');

			//Initialize carousel
			$this.owlCarousel({
				autoplay: play,
				autoplayHoverPause: pause,
				nav: nav,
				dots: dots,
				mouseDrag: mouse,
				touchDrag: touch,
				loop: loop,
				smartSpeed: partAnim ? 5 : speed,
				navSpeed: partAnim ? 5 : speed,
				autoplaySpeed: speed,
				autoplayTimeout: delay,
				responsive: {
					0: {
						items: 1
					},
				}
			});

			if ( partAnim ) {
				var firstItem = $this.find('.owl-item.active').find("[data-animation ^= 'animated']");
				doAnimations( firstItem );

				var oldActive = [ $this.find('.owl-item.active') ];

				$this.on('translated.owl.carousel', function(e) {
					var newActive = $this.find('.owl-item.active');
					var elems = newActive.find("[data-animation ^= 'animated']");
					doAnimations( elems );

					oldActive.push( newActive );
					oldActive[0].find("[data-animation ^= 'animated']").each(function (index, el) {
						var el = $(this);
						el.addClass( 'charsoogh-anim-invisible' );
					});
					oldActive.shift();
				});
			}

			$this.find('.charsoogh-tooltip').tooltip();
		});
	}

	function charsooghBlogpost($scope, $) {
		$scope.find('.charsoogh-blogpost').each(function () {
			var $this = $(this),
				$isoGrid = $this.children('.charsoogh-bp-grid');

			$this.imagesLoaded( function() {
				$isoGrid.isotope({
					itemSelector: '.charsoogh-bp-col',
					percentPosition: true,
					masonry: {
						columnWidth: '.charsoogh-bp-grid-sizer',
					}
				});
			});

			var uid = $this.data('uid'),
				postsData = $this.data('posts-data'),
				totalPosts = postsData.total_posts,
				postsNum = postsData.posts_num,
				nonce = $this.find('#charsoogh_load_more_posts'+uid),
				loadMore = $this.find('.charsoogh-load-more'),
				btn = loadMore.children('.charsoogh-load-more-btn'),
				btn = loadMore.children('.charsoogh-load-more-btn'),
				btnText = btn.html();

			btn.on('click', function(e) {
				var offset = $this.data('offset');
				btn.html('Loading...');
				$.post(
					charsooghAjax.ajaxURL,
					{
						action: "charsoogh_load_more_posts",
						posts_data: JSON.stringify(postsData),
						offset: offset,
						nonce: nonce.val(),
					},
					function( data, status, code ) {
						if ( status == 'success' ) {
							var $items = $(data).find('.charsoogh-bp-col');
							$isoGrid.append($items);
							imagesLoaded($isoGrid, function() {
							    $isoGrid.isotope('appended', $items);
							});

							if ( offset >= (totalPosts - postsNum) ) {
								loadMore.remove()
							}

							btn.html(btnText);
							$this.data('offset', offset + postsNum);
						}
					}
				);
			});

		});
	}

	function charsooghFbFeed($scope, $) {
		$scope.find('.charsoogh-facebook-feed').each(function () {
			var $this = $(this),
				$isoGrid = $this.children('.charsoogh-feed-grid');

			$this.imagesLoaded( function() {
				$isoGrid.isotope({
					itemSelector: '.charsoogh-feed-col',
					percentPosition: true,
					masonry: {
						columnWidth: '.charsoogh-fb-feed-grid-sizer',
					}
				});
			});
		});
	}

	function charsooghTwitterFeed($scope, $) {
		$scope.find('.charsoogh-twitter-feed').each(function () {
			var $this = $(this),
				$isoGrid = $this.children('.charsoogh-feed-grid');

			$this.imagesLoaded( function() {
				$isoGrid.isotope({
					itemSelector: '.charsoogh-feed-col',
					percentPosition: true,
					masonry: {
						columnWidth: '.charsoogh-twitter-feed-grid-sizer',
					}
				});
			});
		});
	}

	function charsooghContactForm($scope, $) {
		$scope.find('.charsoogh-contact-form').each(function () {
			var $this = $(this),
				$uid = $this.data('uid'),
				$inbox = $this.data('inbox'),
				$nonce = $this.children('#charsoogh_contact_nonce'+$uid),
				$success = $this.children('.charsoogh-success-text'),
				$error = $this.children('.charsoogh-error-text'),
				$process = $this.children('.charsoogh-process-text'),
				$name = $this.find('.charsoogh-input-name'),
				$email = $this.find('.charsoogh-input-email'),
				$subject = $this.find('.charsoogh-input-subject'),
				$message = $this.find('.charsoogh-input-message'),
				$isCaptcha = $this.data('captcha') ? true : false,
				timeout;

			$this.on('submit', function(e) {
				e.preventDefault();
				clearTimeout(timeout);

				$error.fadeOut(0);
				$success.fadeOut(0);
				$process.fadeIn(200);

				var captcha = '';
				if ( $isCaptcha ) {
					captcha = grecaptcha.getResponse();
				}

				$.post(
					charsooghAjax.ajaxURL,
					{
						action: "charsoogh_contact",
						inbox: $inbox,
						name: $name.val(),
						email: $email.val(),
						subject: $subject.val(),
						message: $message.val(),
						is_captcha: $isCaptcha,
						captcha: captcha,
						nonce: $nonce.val(),
					},
					function( data, status, code ) {
						if ( status == 'success' ) {
							if ( data ) {
								$process.fadeOut(0);
								$error.html( data ).fadeIn(200);

								timeout = setTimeout( function() {
									$error.fadeOut(200);
								}, 10000 );
							} else{
								$process.fadeOut(0);
								$success.fadeIn(200);

								timeout = setTimeout( function() {
									$success.fadeOut(200);
								}, 10000 );
							}
						}
					}
				);

			});
		});
	}

	function charsooghTable($scope, $) {
		$scope.find('.charsoogh-table').each(function () {
			var $this = $(this),
				$table = $this.find('.charsoogh-data-table'),
				$tableInfo = $this.data('table-info'),
				head = $tableInfo.head ? $tableInfo.head : [],
				source = $tableInfo.external_source ? $tableInfo.external_source : '',
				exportBtns = $tableInfo.export ? 'Blftrip' : 'lftrip',
				ordering = $tableInfo.ordering ? true : false,
				order = $tableInfo.sort_col ? $tableInfo.sort_col : 2,
				sortType = $tableInfo.sort_type ? $tableInfo.sort_type : 'desc',
				searching = $tableInfo.searching ? true : false,
				info = $tableInfo.info ? true : false,
				paging = $tableInfo.paging ? true : false,
				pagingType = $tableInfo.pagingType ? $tableInfo.pagingType : 'simple_numbers';

			$table.DataTable({
				ajax: source,
				columns: head,
				ordering : ordering,
				order: [[ order - 1, sortType ]],
				searching : searching,
				info : info,
				paging : paging,
				pagingType : pagingType,
				dom: exportBtns,
			});
		});
	}

	function charsooghLoginForm($scope, $) {
		$scope.find('.charsoogh-login-form').each(function () {
			var $this = $(this),
				$uid = $this.data('uid'),
				$url = $this.data('url'),
				$remLog = $this.data('rem-login'),
				$nonce = $this.children('#charsoogh_login_nonce'+$uid),
				$error = $this.children('.charsoogh-error-text'),
				$password = $this.children('.charsoogh-input-password'),
				$email = $this.children('.charsoogh-input-email'),
				$rememberText = $this.find('.charsoogh-login-remember'),
				$logBtn = $this.find('.charsoogh-login-btn'),
				btnHtml = $logBtn.html(),
				timeout,
				remeber = false;

				if ( 'yes' == $remLog ) {
					remeber = $rememberText.prop('checked');
				}

			$this.on('submit', function(e) {
				e.preventDefault();
				clearTimeout(timeout);

				$logBtn.html('Logging...');
				$error.fadeOut(0);

				$.post(
					charsooghAjax.ajaxURL,
					{
						action: "charsoogh_login",
						password: $password.val(),
						email: $email.val(),
						remember: remeber,
						nonce: $nonce.val(),
					},
					function( data, status, code ) {
						if ( status == 'success' ) {
							if ( data ) {
								$error.html( data ).fadeIn(200);

								timeout = setTimeout( function() {
									$error.fadeOut(200);
								}, 10000 );
							} else{
								location.href = $url;
							}
							$logBtn.html(btnHtml);
						}
					}
				);
			});
		});
	}

	function charsooghMCSubscribe($scope, $) {
		$scope.find('.charsoogh-subs-form').each(function () {
			var $this = $(this),
				$uid = $this.data('uid'),
				$nonce = $this.find('#charsoogh_mc_subscribe_nonce'+$uid),
				$fname = $this.find('.charsoogh-input-fname'),
				$lname = $this.find('.charsoogh-input-lname'),
				$email = $this.find('.charsoogh-input-email'),
				$phone = $this.find('.charsoogh-input-phone'),
				$success = $this.children('.charsoogh-success-text'),
				$error = $this.children('.charsoogh-error-text'),
				$process = $this.children('.charsoogh-process-text'),
				timeout;

			$this.on('submit', function(e) {
				e.preventDefault();
				clearTimeout(timeout);

				$error.fadeOut(0);
				$success.fadeOut(0);
				$process.fadeIn(200);


				$.post(
					charsooghAjax.ajaxURL,
					{
						action: "charsoogh_mc_subscribe",
						fname: $fname.val() || ' ',
						lname: $lname.val() || ' ',
						phone: $phone.val() || ' ',
						email: $email.val(),
						nonce: $nonce.val(),
					},
					function( data, status, code ) {
						if ( status == 'success' ) {
							if ( 'success' == data ) {
								$process.fadeOut(0);
								$success.fadeIn(200);

								timeout = setTimeout( function() {
									$success.fadeOut(200);
								}, 10000 );
							} else{
								$process.fadeOut(0);
								$error.html( data ).fadeIn(200);

								timeout = setTimeout( function() {
									$error.fadeOut(200);
								}, 10000 );
							}
						}
					}
				);

			});
		});
	}

	var faToEnDigits = function (input) {
	        if (input == undefined)
	            return;
	        var returnModel = "", symbolMap = {
	            '۱': '1',
	            '۲': '2',
	            '۳': '3',
	            '۴': '4',
	            '۵': '5',
	            '۶': '6',
	            '۷': '7',
	            '۸': '8',
	            '۹': '9',
	            '۰': '0'
	        };
	        input = input.toString();
	        for (var i = 0; i < input.length; i++)
	            if (symbolMap[input[i]])
	                returnModel += symbolMap[input[i]];
	            else
	                returnModel += input[i];
	        return returnModel;
	}

	function charsooghCountdown($scope, $) {
		$scope.find('.charsoogh-countdown').each(function (item , index) {
			var $this = $(this),
				year  = $this.find('.charsoogh-cd-year'),
				month = $this.find('.charsoogh-cd-month'),
				week  = $this.find('.charsoogh-cd-week'),
				day   = $this.find('.charsoogh-cd-day'),
				hour  = $this.find('.charsoogh-cd-hour'),
				min   = $this.find('.charsoogh-cd-minute'),
				sec   = $this.find('.charsoogh-cd-second'),
				text  = $this.data('text'),
				mesg  = $this.data('message'),
				link   = $this.data('link'),
				time  = $this.data('time');

			$this.countdown( time ).on('update.countdown', function (e) {
				var m = e.strftime('%m'),
					w = e.strftime('%w'),
					Y = Math.floor(m / 12),
					m = m % 12,
					w = w % 4;


				year.html( addZero(Y) );
				month.html( addZero(m) );
				week.html( '0'+w );
				day.html( e.strftime('%d') );
				hour.html( e.strftime('%H') );
				min.html( e.strftime('%M') );
				sec.html( e.strftime('%S') );


				if ( text == 'yes' ) {
					year.next().html( Y < 2 ? 'Year' : 'Years' );
					month.next().html( m < 2 ? 'Month' : 'Months' );
					week.next().html( w < 2 ? 'Week' : 'Weeks' );
					day.next().html( e.strftime('%d') < 2 ? 'Day' : 'Days' );
					hour.next().html( e.strftime('%H') < 2 ? 'Hour' : 'Hours' );
					min.next().html( e.strftime('%M') < 2 ? 'Minute' : 'Minutes' );
					sec.next().html( e.strftime('%S') < 2 ? 'Second' : 'Seconds' );
				}

			}).on('finish.countdown', function (e) {
				$this.children().remove();
				if ( mesg ) {
					$this.append('<div class="charsoogh-cd-message">'+ mesg +'</div>');
				} else if( link && elementorFrontend.isEditMode() ){
					$this.append('<h2>You can\'t redirect url from elementor edit mode!!</h2>');
				} else if (link) {
					window.location.href = link;
				} else{
					$this.append('<h2>May be you don\'t enter a valid redirect url</h2>');
				}
			});
		});
	}

	function charsooghCounter($scope, $) {
		elementorFrontend.waypoint($scope.find('.charsoogh-counter-number'), function () {
			var $this 	= $(this),
				data 	= $this.data(),
				digit	= data.toValue.toString().match(/\.(.*)/);

			if (digit) {
				data.rounding = digit[1].length;
			}

			$this.numerator(data);
		});
	}

	function charsooghFancytext($scope, $) {
		$scope.find('.charsoogh-fancytext').each(function () {
			var $this = $(this),
				strings = $this.find('.charsoogh-fancytext-strings'),
				anim = $this.data('anim'),
				speed = $this.data('speed'),
				delay = $this.data('delay'),
				cursor = $this.data('cursor') ? true : false,
				loop = $this.data('loop') ? true : false,
				fancyText = $this.data('fancy-text'),
				fancyText = fancyText.split('@@');

			if ( 'typing' == anim ) {
				strings.typed({
					strings: fancyText,
					typeSpeed: speed,
					startDelay: delay,
					showCursor: cursor,
					loop: loop,
				});
			} else{
				strings.Morphext({
					animation: anim,
					separator: '@@',
					speed: delay
				});
			}
		});
	}

	function charsooghGoogleMap($scope, $) {
		$scope.find('.charsoogh-google-map').each(function () {
			var $this = $(this),
				$id = $this.data('id'),
				$anim = $this.data('anim'),
				$zoom = $this.data('zoom'),
				$lat = $this.data('lat'),
				$long = $this.data('long'),
				$isMarker = $this.data('marker'),
				$marker = $this.data('marker-link');

			var map = new google.maps.Map(document.getElementById($id), {
				center: {
					lat: $lat,
					lng: $long
				},
				zoom: $zoom
			});

			if ( $isMarker && $marker ) {
				var marker = new google.maps.Marker({
					position: new google.maps.LatLng($lat, $long),
					map: map,
					icon: {
						url: $marker,
					},
					animation: google.maps.Animation[$anim]
				});
			}
		});
	}

	function charsooghImageDiffer($scope, $) {
		$scope.find('.charsoogh-image-differ').each(function () {
			var $this = $(this),
				orientation = $this.data('orientation'),
				before = $this.data('before'),
				after = $this.data('after'),
				offset = $this.data('offset'),
				overlay = $this.data('overlay') ? true : false,
				click = $this.data('click') ? true : false,
				hover = $this.data('hover') ? true : false,
				$cont = $this.children('.twentytwenty-container');

			$cont.twentytwenty({
				default_offset_pct: offset,
				orientation: orientation,
				before_label: before,
				after_label: after,
				no_overlay: overlay,
				move_slider_on_hover: hover,
				click_to_move: click,
			});
		});
	}

	function charsooghNewsTicker($scope, $) {
		$scope.find('.charsoogh-news-ticker').each(function () {
			var $ticker = $(this),
				speed = $ticker.data('speed'),
				pause = ('yes' == $ticker.data('pause')) ? true : false,
				wrapper = $ticker.children('.charsoogh-news-wrapper'),
				newsContainer = wrapper.children('.charsoogh-news-container'),
				newsContent = newsContainer.children('.charsoogh-news-content'),
				news = newsContent.children('.charsoogh-news'),
				wrapWid = wrapper.outerWidth(),
				newsContentWid = 0;

			news.each(function(index, el) {
				newsContentWid += $(this).outerWidth();
			});
			newsContentWid += wrapWid * 0.5;

			newsContent.css('width', newsContentWid +'px');
			newsContent.clone().appendTo(newsContainer);

			function newsTicker(sp, ps) {
				var duration = newsContentWid*sp;

				newsContainer.css({
					width 		: newsContentWid*2 +'px',
					marginLeft	: 0,
				});
				newsContainer.animate({
					marginLeft:'-='+newsContentWid+'px'
				}, duration, 'linear', function () {
					newsTicker(sp, ps);
				});
			}

			if ( pause ) {
				newsContainer.on('mouseenter', function(e) {
					newsContainer.stop();
				});
				newsContainer.on('mouseleave', function(e) {
					var marLeft = newsContainer.css('marginLeft');
						marLeft = marLeft.replace(/px/i, '');
					var newContentWid = parseInt(marLeft) + newsContentWid;

					newsContainer.animate({
						marginLeft:'-='+newContentWid+'px'
					}, newContentWid*speed, 'linear', function () {
						newsTicker(speed, pause);
					});
				});
			}
			newsTicker(speed, pause);
		});
	}

	function charsooghProductZoomer($scope, $) {
		$scope.find('.charsoogh-product-zoomer').each(function () {
			var $this = $(this),
				position = $this.data('position'),
				shape = $this.data('shape');

			$this.find('.xzoom, .xzoom-gallery').xzoom({
				position: position,
				lensShape: shape,
			});
		});
	}

	function charsooghParticleLayer($scope, $) {
		$scope.find('.charsoogh-particle').each(function () {
			var $this = $(this),
				linkColor = $this.data('link-color'),
				ballColor = $this.data('ball-color'),
				number = $this.data('number'),
				link = $this.data('link'),
				clink = $this.data('clink'),
				linkw = $this.data('linkw'),
				size = $this.data('size'),
				speed = $this.data('speed'),
				dlink = $this.data('dlink') ? true : false,
				dmouse = $this.data('dmouse') ? true : false;

			$this.charsooghParticles({
				lineColor: linkColor,
				fillColor: ballColor,
				particlesNumber: number,
				linkDist: link,
				createLinkDist: clink,
				linksWidth: linkw,
				maxSize: size,
				speed: speed,
				disableLinks: dlink,
				disableMouse: dmouse
			});

		});

		$('.charsoogh-particle-layer .charsoogh-tooltip').tooltip();
	}

	function charsooghPiechart($scope, $) {
		elementorFrontend.waypoint($scope.find('.charsoogh-piechart-wrap'), function () {
			var $this 		= $(this),
				trackColor	= $this.data('track'),
				trackWidth	= $this.data('track-width'),
				barColor	= $this.data('bar'),
				lineWidth	= $this.data('line'),
				lineCap		= $this.data('cap'),
				animSpeed	= $this.data('speed'),
				scale		= $this.data('scale'),
				size		= $this.data('size');

			$this.easyPieChart({
				trackColor: trackColor,
				barColor: barColor,
				lineWidth: lineWidth,
				lineCap: lineCap,
				animate: animSpeed,
				scaleColor: scale,
				size: size
			});
		});
	}

	function charsooghPortfolio($scope, $) {
		$scope.find('.charsoogh-portfolio').each(function () {
			var $this = $(this),
				$isoGrid = $this.children('.charsoogh-portfolio-grid'),
				$btns = $this.children('.charsoogh-portfolio-btns'),
				layout = $this.data('layout');

			$this.imagesLoaded( function() {
				if ( 'masonry' == layout ) {
					var $grid = $isoGrid.isotope({
						itemSelector: '.charsoogh-portfolio-item',
						percentPosition: true,
						masonry: {
							columnWidth: '.charsoogh-portfolio-item',
						}
					});
				} else{
					var $grid = $isoGrid.isotope({
						itemSelector: '.charsoogh-portfolio-item',
						layoutMode: 'fitRows'
					});
				}

				$btns.on('click', 'button', function () {
					var filterValue = $(this).attr('data-filter');
					$grid.isotope({filter: filterValue});
				});

				$btns.each(function (i, btns) {
					var btns = $(btns);

					btns.on('click', '.charsoogh-portfolio-btn', function () {
						btns.find('.is-checked').removeClass('is-checked');
						$(this).addClass('is-checked');
					});
				});
			});

			$this.find('.charsoogh-portfolio-zoom').magnificPopup({
				type: 'image',
				gallery: {
					enabled: true
				},
			});

		});
	}

	function charsooghPostsTab($scope, $) {
		$scope.find('.charsoogh-posts-tab').each(function () {
			var $btn = $("[data-charsoogh-pt]");

			$btn.on('click', function(e) {
				$( $(this).data('charsoogh-pt') ).siblings('.charsoogh-pt-item').removeClass('active');
				$( $(this).data('charsoogh-pt') ).addClass('active');
			});
		});
	}

	function charsooghProgressbars($scope, $) {
		elementorFrontend.waypoint($scope.find('.charsoogh-bar-content'), function () {
			var $this = $(this),
				$perc = $this.data('percentage');

			$this.animate({ width: $perc + '%' }, $perc * 20 );
		});
	}

	function charsooghModalBox($scope, $) {
		$scope.find('.charsoogh-modal-box').each(function () {
			var $this = $(this),
				$click = $this.data('click') ? true : false,
				$esc = $this.data('esc') ? true : false,
				$aShow = $this.data('auto-show') ? true : false,
				$dShow = $this.data('delay-show') ? $this.data('delay-show') : 4000,
				$id = $this.data('modal-id'),
				$btn = $('.'+$id),
				$cBtn = $this.find('.close-'+$id),
				$modal = $('.charsoogh-modal-'+$id);

			$btn.click( function(e) {
				e.preventDefault();
				$modal.fadeIn( 400 );
			});

			$cBtn.click( function() {
				$modal.fadeOut(400);
			});

			if ( $aShow ) {
				setTimeout( function() { $modal.fadeIn( 400 ); }, $dShow );
			}

			if ( $click ) {
				$(document).on('click', function(e) {
					if ( $(e.target).is('.charsoogh-modal-area') ) {
						$modal.fadeOut(400);
					}
				});
			}

			if ( $esc ) {
				$(window).on('keydown', function(e) {
					var key = e.which || e.keyCode;
					if ( 192 == key ) {
						$modal.fadeOut(400);
					}
				});
			}
		});
	}

	function charsooghUserCounter($scope, $) {
		$scope.find('.charsoogh-user-counter').each(function () {
			var $this = $(this),
				number = $this.children('.charsoogh-uc-number'),
				roles = $this.data('roles'),
				nonce = $this.find('#charsoogh_user_counter_nonce');

			setInterval( function() {
				$.post(
					charsooghAjax.ajaxURL,
					{
						action: "charsoogh_user_counter",
						roles: roles,
						nonce: nonce.val(),
					},
					function( data, status, code ) {
						if ( status == 'success' ) {
							number.html(data);
						}
					}
				);
			}, 5000);
		});
	}

	function charsooghVideo($scope, $) {
		$scope.find('.charsoogh-video').each(function () {
			$(this).children('.charsoogh-video-play').magnificPopup({
				type: 'iframe'
			});
		});
	}

	function charsooghVisitCounter($scope, $) {
		$scope.find('.charsoogh-visit-counter').each(function () {
			var $this = $(this),
				page = $this.data('page'),
				today = $this.find('.charsoogh-visit-today'),
				yesterday = $this.find('.charsoogh-visit-yesterday'),
				nonce = $this.find('#charsoogh_visit_counter_nonce');

			setInterval( function() {
				$.post(
					charsooghAjax.ajaxURL,
					{
						action: "charsoogh_visit_counter",
						page: page,
						nonce: nonce.val(),
					},
					function( data, status, code ) {
						if ( status == 'success' ) {
							data = data.split('|');
							today.html(data['0']);
							yesterday.html(data['1']);
						}
					}
				);
			}, 5000);
		});
	}


	$(window).on('elementor/frontend/init', function () {
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_accordion.default', charsooghAccordion);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_banner_slider.default', charsooghBannerSlider);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_blogpost.default', charsooghBlogpost);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_facebook_feed.default', charsooghFbFeed);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_twitter_feed.default', charsooghTwitterFeed);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_brand_carousel.default', charsooghBrandCarousel);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_contact_form.default', charsooghContactForm);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_table.default', charsooghTable);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_login_form.default', charsooghLoginForm);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_mc_subscribe.default', charsooghMCSubscribe);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_content_slider.default', charsooghContentSlider);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_posts_carousel.default', charsooghPostsCarousel);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_countdown.default', charsooghCountdown);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_counter.default', charsooghCounter);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_fancytext.default', charsooghFancytext);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_image_differ.default', charsooghImageDiffer);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_google_map.default', charsooghGoogleMap);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_news_ticker.default', charsooghNewsTicker);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_product_zoomer.default', charsooghProductZoomer);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_particle_layer.default', charsooghParticleLayer);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_piechart.default', charsooghPiechart);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_portfolio.default', charsooghPortfolio);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_posts_tab.default', charsooghPostsTab);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_progressbar.default', charsooghProgressbars);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_review_carousel.default', charsooghReviewCarousel);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_modal_box.default', charsooghModalBox);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_user_counter.default', charsooghUserCounter);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_video.default', charsooghVideo);
		elementorFrontend.hooks.addAction('frontend/element_ready/charsoogh_visit_counter.default', charsooghVisitCounter);
	});

})(jQuery);
