<!DOCTYPE html>
<!-- Design by Tik4.com -->
<!--[if lt IE 7 ]> <html class="ie6" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 7 ]>    <html class="ie7" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 8 ]>    <html class="ie8" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 9 ]>    <html class="ie9" <?php language_attributes(); ?>> <![endif]-->
<!--[if (gt IE 9)|!(IE)]><!--> <html <?php language_attributes(); ?>> <!--<![endif]-->
  <head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="author" content="Tik4">
  	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
  	<meta http-equiv="X-UA-Compatible" content="IE=edge">
  	<meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="<?php bloginfo('stylesheet_url');?>" type="text/css" media="screen">
    <link rel="shortcut icon" type="image/png" href="<?php if (get_theme_mod( 'charsoogh_favicon' )) : echo get_theme_mod( 'charsoogh_favicon'); else: echo IMAGES . '/favicon.png'; endif; ?>"/>
    <link rel="apple-touch-icon" href="<?php if (get_theme_mod( 'charsoogh_favicon' )) : echo get_theme_mod( 'charsoogh_favicon'); else: echo IMAGES . '/favicon.png'; endif; ?>" />
    <?php
    if(is_single() || is_product()):
    $image = get_the_post_thumbnail_url(get_the_ID(),'full');
    else:
    if (get_theme_mod( 'charsoogh_favicon' )) : $image = get_theme_mod( 'charsoogh_favicon');else: $image = IMAGES . '/favicon.png';endif;
    endif;
    ?>
    <meta property="og:image" content="<?php echo $image; ?>">
    <meta name="twitter:image" content="<?php echo $image; ?>">
    <?php wp_head(); ?>
    <?php get_template_part('includes/style-options'); ?>
  </head>
<body <?php body_class(); ?>>
  <div class="hero">
  <div class="main-navigation">
  <nav class="navbar navbar-expand-lg navbar-light justify-content-between full-map-header">
      <a class="navbar-brand" href="<?php echo site_url(); ?>">
          <img src="<?php if (get_theme_mod( 'charsoogh_general_logo' )) : echo get_theme_mod( 'charsoogh_general_logo'); else: echo get_template_directory_uri().'/assets/img/logo.png'; endif; ?>" alt="<?php echo get_theme_mod('charsoogh_main_general_title'); ?>">
      </a>
      <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbar" aria-controls="navbar" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse" id="navbar">
          <!--Main navigation list-->
          <?php
          wp_nav_menu( array(
            'theme_location'  => 'main-menu',
            'depth'	          => 10,
            'container'       => false,
            'menu_class'      => 'navbar-nav',
            'fallback_cb'     => 'WP_Bootstrap_Navwalker::fallback',
            'walker'          => new WP_Bootstrap_Navwalker(),
          ) );
          ?>
      </div>
      <ol class="nav-btn">
      <?php if (get_theme_mod( 'charsoogh_category_button') != 'no') : ?>
      <li class="top-category-btn" <?php if (get_theme_mod( 'charsoogh_submit_ad_show') == 'no'){echo 'style="width:100%"';} ?>>
      <button type="button" class="btn btn-primary text-caps btn-rounded btn-framed" data-toggle="modal" data-target="#charsoogh_category_show"><i class="fa fa-align-justify" aria-hidden="true"></i> <?php _e('Categories' , 'charsoogh'); ?></button>
      </li>
      <?php endif; ?>
      <?php if (get_theme_mod( 'charsoogh_submit_ad_show') != 'no') : ?>
      <li class="nav-item submit_ad" <?php if (get_theme_mod( 'charsoogh_category_button') == 'no'){echo 'style="width:100%;display: inherit;"';}?>>
        <?php if (get_theme_mod( 'charsoogh_ad_page' )) : $newad_page_id = get_theme_mod( 'charsoogh_ad_page'); else: $newad_page_id = get_site_option( 'newad_page_id' ); endif; ?>
          <button type="button" class="btn btn-primary text-caps btn-rounded btn-framed submit-new-modal" data-toggle="modal" data-target="#charsoogh_submit_ad_show">
            <i class="fa fa-plus" aria-hidden="true"></i> <?php if (get_theme_mod( 'charsoogh_submit_btn_title' )) : echo get_theme_mod( 'charsoogh_submit_btn_title'); else: echo __('Free ad Submission' , 'charsoogh'); endif; ?>
          </button>
      </li>
    <?php endif; ?>
    <li>
      <button type="button" class="main-search-form-toggle" data-toggle="modal" data-target="#charsoogh_search_modal"><i class="fa fa-search"></i></button>
    </li>
  </ol>
  </nav>
  </div>
</div>
