<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains comments and the comment form.
 *
 * @package WordPress
 * @subpackage Twenty_Thirteen
 * @since Twenty Thirteen 1.0
 */

/*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() )
    return;
?>
<section class="comments-section">
<?php if ( have_comments() ) : ?>
  <div class="<?php if (get_theme_mod( 'charsoogh_comment_title_style' )) : echo get_theme_mod( 'charsoogh_comment_title_style'); else: echo 'section-title'; endif; ?> clearfix">
  <h2><?php if (get_theme_mod( 'charsoogh_comment_title' )) : echo get_theme_mod( 'charsoogh_comment_title'); else: echo __('Express your opinion' , 'charsoogh'); endif; ?></h2>
  </div>

    <ol class="comment-list">
        <?php
            wp_list_comments( array(
                'style'       => 'ol',
                'short_ping'  => true,
                'avatar_size' => 74,
            ) );
        ?>
    </ol><!-- .comment-list -->

    <?php
        // Are there comments to navigate through?
        if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
    ?>
    <nav class="navigation comment-navigation" role="navigation">
        <h1 class="screen-reader-text section-heading"><?php _e( 'Comment navigation', 'charsoogh' ); ?></h1>
        <div class="nav-previous"><?php previous_comments_link( __( '&larr; Older Comments', 'charsoogh' ) ); ?></div>
        <div class="nav-next"><?php next_comments_link( __( 'Newer Comments &rarr;', 'charsoogh' ) ); ?></div>
    </nav><!-- .comment-navigation -->
    <?php endif; // Check for comment navigation ?>

    <?php if ( ! comments_open() && get_comments_number() ) : ?>
    <p class="no-comments"><?php _e( 'Comments are closed.' , 'charsoogh' ); ?></p>
    <?php endif; ?>

<?php endif; // have_comments() ?>
<div id="comments" class="comments-area">

    <?php comment_form(); ?>

</div><!-- #comments -->
</section>
